/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Outlined.ReadMore",
    ReplaceWith( "Icons.AutoMirrored.Outlined.ReadMore",
            "androidx.compose.material.icons.automirrored.outlined.ReadMore"),
)
public val Icons.Outlined.ReadMore: ImageVector
    get() {
        if (_readMore != null) {
            return _readMore!!
        }
        _readMore = materialIcon(name = "Outlined.ReadMore") {
            materialPath {
                moveTo(13.0f, 7.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-9.0f)
                close()
            }
            materialPath {
                moveTo(13.0f, 15.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-9.0f)
                close()
            }
            materialPath {
                moveTo(16.0f, 11.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-6.0f)
                close()
            }
            materialPath {
                moveTo(13.0f, 12.0f)
                lineToRelative(-5.0f, -5.0f)
                lineToRelative(0.0f, 4.0f)
                lineToRelative(-6.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(6.0f, 0.0f)
                lineToRelative(0.0f, 4.0f)
                close()
            }
        }
        return _readMore!!
    }

private var _readMore: ImageVector? = null
