/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled._10k: ImageVector
    get() {
        if (__10k != null) {
            return __10k!!
        }
        __10k = materialIcon(name = "Filled._10k") {
            materialPath {
                moveTo(10.0f, 10.5f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(3.0f)
                lineTo(10.0f, 13.5f)
                close()
                moveTo(19.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(7.5f, 15.0f)
                lineTo(6.0f, 15.0f)
                verticalLineToRelative(-4.5f)
                lineTo(4.5f, 10.5f)
                lineTo(4.5f, 9.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(6.0f)
                close()
                moveTo(13.0f, 14.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                lineTo(9.5f, 15.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                lineTo(12.0f, 9.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                close()
                moveTo(19.5f, 15.0f)
                horizontalLineToRelative(-1.75f)
                lineTo(16.0f, 12.75f)
                lineTo(16.0f, 15.0f)
                horizontalLineToRelative(-1.5f)
                lineTo(14.5f, 9.0f)
                lineTo(16.0f, 9.0f)
                verticalLineToRelative(2.25f)
                lineTo(17.75f, 9.0f)
                horizontalLineToRelative(1.75f)
                lineToRelative(-2.25f, 3.0f)
                lineToRelative(2.25f, 3.0f)
                close()
            }
        }
        return __10k!!
    }

private var __10k: ImageVector? = null
