/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.SurroundSound: ImageVector
    get() {
        if (_surroundSound != null) {
            return _surroundSound!!
        }
        _surroundSound = materialIcon(name = "Filled.SurroundSound") {
            materialPath {
                moveTo(20.0f, 4.0f)
                lineTo(4.0f, 4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(22.0f, 6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(7.76f, 16.24f)
                lineToRelative(-1.41f, 1.41f)
                curveTo(4.78f, 16.1f, 4.0f, 14.05f, 4.0f, 12.0f)
                curveToRelative(0.0f, -2.05f, 0.78f, -4.1f, 2.34f, -5.66f)
                lineToRelative(1.41f, 1.41f)
                curveTo(6.59f, 8.93f, 6.0f, 10.46f, 6.0f, 12.0f)
                reflectiveCurveToRelative(0.59f, 3.07f, 1.76f, 4.24f)
                close()
                moveTo(12.0f, 16.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                reflectiveCurveToRelative(1.79f, -4.0f, 4.0f, -4.0f)
                reflectiveCurveToRelative(4.0f, 1.79f, 4.0f, 4.0f)
                reflectiveCurveToRelative(-1.79f, 4.0f, -4.0f, 4.0f)
                close()
                moveTo(17.66f, 17.66f)
                lineToRelative(-1.41f, -1.41f)
                curveTo(17.41f, 15.07f, 18.0f, 13.54f, 18.0f, 12.0f)
                reflectiveCurveToRelative(-0.59f, -3.07f, -1.76f, -4.24f)
                lineToRelative(1.41f, -1.41f)
                curveTo(19.22f, 7.9f, 20.0f, 9.95f, 20.0f, 12.0f)
                curveToRelative(0.0f, 2.05f, -0.78f, 4.1f, -2.34f, 5.66f)
                close()
                moveTo(12.0f, 10.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                close()
            }
        }
        return _surroundSound!!
    }

private var _surroundSound: ImageVector? = null
