/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.ScreenSearchDesktop: ImageVector
    get() {
        if (_screenSearchDesktop != null) {
            return _screenSearchDesktop!!
        }
        _screenSearchDesktop = materialIcon(name = "Filled.ScreenSearchDesktop") {
            materialPath {
                moveTo(20.0f, 18.0f)
                curveTo(21.1f, 18.0f, 21.99f, 17.1f, 21.99f, 16.0f)
                lineTo(22.0f, 6.0f)
                curveTo(22.0f, 4.89f, 21.1f, 4.0f, 20.0f, 4.0f)
                lineTo(4.0f, 4.0f)
                curveTo(2.89f, 4.0f, 2.0f, 4.89f, 2.0f, 6.0f)
                lineTo(2.0f, 16.0f)
                curveTo(2.0f, 17.1f, 2.89f, 18.0f, 4.0f, 18.0f)
                lineTo(0.0f, 18.0f)
                lineTo(0.0f, 20.0f)
                lineTo(24.0f, 20.0f)
                lineTo(24.0f, 18.0f)
                lineTo(20.0f, 18.0f)
                close()
                moveTo(4.0f, 16.0f)
                lineTo(4.0f, 6.0f)
                lineTo(20.0f, 6.0f)
                lineTo(20.0f, 16.0f)
                lineTo(20.0f, 16.01f)
                lineTo(4.0f, 16.0f)
                close()
                moveTo(9.097f, 9.953f)
                curveTo(9.097f, 8.926f, 9.933f, 8.089f, 10.961f, 8.089f)
                curveTo(11.988f, 8.089f, 12.825f, 8.926f, 12.825f, 9.953f)
                curveTo(12.825f, 10.98f, 11.988f, 11.817f, 10.961f, 11.817f)
                curveTo(9.933f, 11.817f, 9.097f, 10.98f, 9.097f, 9.953f)
                close()
                moveTo(16.129f, 14.189f)
                lineTo(13.647f, 11.707f)
                curveTo(13.978f, 11.202f, 14.174f, 10.6f, 14.174f, 9.953f)
                curveTo(14.174f, 8.181f, 12.733f, 6.74f, 10.961f, 6.74f)
                curveTo(9.189f, 6.74f, 7.747f, 8.181f, 7.747f, 9.953f)
                curveTo(7.747f, 11.725f, 9.189f, 13.167f, 10.961f, 13.167f)
                curveTo(11.597f, 13.167f, 12.186f, 12.975f, 12.685f, 12.656f)
                lineTo(15.174f, 15.144f)
                lineTo(16.129f, 14.189f)
                close()
            }
        }
        return _screenSearchDesktop!!
    }

private var _screenSearchDesktop: ImageVector? = null
