/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.FormatColorReset: ImageVector
    get() {
        if (_formatColorReset != null) {
            return _formatColorReset!!
        }
        _formatColorReset = materialIcon(name = "Filled.FormatColorReset") {
            materialPath {
                moveTo(18.0f, 14.0f)
                curveToRelative(0.0f, -4.0f, -6.0f, -10.8f, -6.0f, -10.8f)
                reflectiveCurveToRelative(-1.33f, 1.51f, -2.73f, 3.52f)
                lineToRelative(8.59f, 8.59f)
                curveToRelative(0.09f, -0.42f, 0.14f, -0.86f, 0.14f, -1.31f)
                close()
                moveTo(17.12f, 17.12f)
                lineTo(12.5f, 12.5f)
                lineTo(5.27f, 5.27f)
                lineTo(4.0f, 6.55f)
                lineToRelative(3.32f, 3.32f)
                curveTo(6.55f, 11.32f, 6.0f, 12.79f, 6.0f, 14.0f)
                curveToRelative(0.0f, 3.31f, 2.69f, 6.0f, 6.0f, 6.0f)
                curveToRelative(1.52f, 0.0f, 2.9f, -0.57f, 3.96f, -1.5f)
                lineToRelative(2.63f, 2.63f)
                lineToRelative(1.27f, -1.27f)
                lineToRelative(-2.74f, -2.74f)
                close()
            }
        }
        return _formatColorReset!!
    }

private var _formatColorReset: ImageVector? = null
