/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.DoneOutline: ImageVector
    get() {
        if (_doneOutline != null) {
            return _doneOutline!!
        }
        _doneOutline = materialIcon(name = "Filled.DoneOutline") {
            materialPath {
                moveTo(19.77f, 5.03f)
                lineToRelative(1.4f, 1.4f)
                lineTo(8.43f, 19.17f)
                lineToRelative(-5.6f, -5.6f)
                lineToRelative(1.4f, -1.4f)
                lineToRelative(4.2f, 4.2f)
                lineTo(19.77f, 5.03f)
                moveToRelative(0.0f, -2.83f)
                lineTo(8.43f, 13.54f)
                lineToRelative(-4.2f, -4.2f)
                lineTo(0.0f, 13.57f)
                lineTo(8.43f, 22.0f)
                lineTo(24.0f, 6.43f)
                lineTo(19.77f, 2.2f)
                close()
            }
        }
        return _doneOutline!!
    }

private var _doneOutline: ImageVector? = null
