/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.AirlineSeatLegroomReduced: ImageVector
    get() {
        if (_airlineSeatLegroomReduced != null) {
            return _airlineSeatLegroomReduced!!
        }
        _airlineSeatLegroomReduced = materialIcon(name = "Filled.AirlineSeatLegroomReduced") {
            materialPath {
                moveTo(19.97f, 19.2f)
                curveToRelative(0.18f, 0.96f, -0.55f, 1.8f, -1.47f, 1.8f)
                horizontalLineTo(14.0f)
                verticalLineToRelative(-3.0f)
                lineToRelative(1.0f, -4.0f)
                horizontalLineTo(9.0f)
                curveToRelative(-1.65f, 0.0f, -3.0f, -1.35f, -3.0f, -3.0f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(5.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                lineToRelative(-2.0f, 7.0f)
                horizontalLineToRelative(1.44f)
                curveToRelative(0.73f, 0.0f, 1.39f, 0.49f, 1.53f, 1.2f)
                close()
                moveTo(5.0f, 12.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(9.0f)
                curveToRelative(0.0f, 2.76f, 2.24f, 5.0f, 5.0f, 5.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(8.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                close()
            }
        }
        return _airlineSeatLegroomReduced!!
    }

private var _airlineSeatLegroomReduced: ImageVector? = null
