/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.HeartBroken: ImageVector
    get() {
        if (_heartBroken != null) {
            return _heartBroken!!
        }
        _heartBroken = materialIcon(name = "TwoTone.HeartBroken") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(9.23f, 5.42f)
                curveTo(8.69f, 5.15f, 8.09f, 5.0f, 7.5f, 5.0f)
                curveTo(5.54f, 5.0f, 4.0f, 6.54f, 4.0f, 8.5f)
                curveToRelative(0.0f, 2.5f, 2.45f, 4.84f, 6.24f, 8.23f)
                lineTo(10.77f, 12.0f)
                horizontalLineTo(7.35f)
                lineTo(9.23f, 5.42f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(16.5f, 5.0f)
                curveToRelative(-0.37f, 0.0f, -0.75f, 0.06f, -1.12f, 0.18f)
                lineTo(14.77f, 7.0f)
                horizontalLineToRelative(2.91f)
                lineToRelative(-2.56f, 8.53f)
                curveTo(17.98f, 12.93f, 20.0f, 10.71f, 20.0f, 8.5f)
                curveTo(20.0f, 6.54f, 18.46f, 5.0f, 16.5f, 5.0f)
                close()
            }
            materialPath {
                moveTo(16.5f, 3.0f)
                curveToRelative(-0.96f, 0.0f, -1.9f, 0.25f, -2.73f, 0.69f)
                lineTo(12.0f, 9.0f)
                horizontalLineToRelative(3.0f)
                lineToRelative(-3.0f, 10.0f)
                lineToRelative(1.0f, -9.0f)
                horizontalLineToRelative(-3.0f)
                lineToRelative(1.54f, -5.39f)
                curveTo(10.47f, 3.61f, 9.01f, 3.0f, 7.5f, 3.0f)
                curveTo(4.42f, 3.0f, 2.0f, 5.42f, 2.0f, 8.5f)
                curveToRelative(0.0f, 4.13f, 4.16f, 7.18f, 10.0f, 12.5f)
                curveToRelative(5.47f, -4.94f, 10.0f, -8.26f, 10.0f, -12.5f)
                curveTo(22.0f, 5.42f, 19.58f, 3.0f, 16.5f, 3.0f)
                close()
                moveTo(10.24f, 16.73f)
                curveTo(6.45f, 13.34f, 4.0f, 11.0f, 4.0f, 8.5f)
                curveTo(4.0f, 6.54f, 5.54f, 5.0f, 7.5f, 5.0f)
                curveToRelative(0.59f, 0.0f, 1.19f, 0.15f, 1.73f, 0.42f)
                lineTo(7.35f, 12.0f)
                horizontalLineToRelative(3.42f)
                lineTo(10.24f, 16.73f)
                close()
                moveTo(15.13f, 15.53f)
                lineTo(17.69f, 7.0f)
                horizontalLineToRelative(-2.91f)
                lineToRelative(0.61f, -1.82f)
                curveTo(15.75f, 5.06f, 16.13f, 5.0f, 16.5f, 5.0f)
                curveTo(18.46f, 5.0f, 20.0f, 6.54f, 20.0f, 8.5f)
                curveTo(20.0f, 10.71f, 17.98f, 12.93f, 15.13f, 15.53f)
                close()
            }
        }
        return _heartBroken!!
    }

private var _heartBroken: ImageVector? = null
