/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.EmojiNature: ImageVector
    get() {
        if (_emojiNature != null) {
            return _emojiNature!!
        }
        _emojiNature = materialIcon(name = "TwoTone.EmojiNature") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(18.0f, 6.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(21.94f, 4.88f)
                curveTo(21.75f, 4.33f, 21.19f, 3.96f, 20.58f, 4.0f)
                horizontalLineTo(19.6f)
                lineToRelative(-0.31f, -0.97f)
                curveTo(19.15f, 2.43f, 18.61f, 2.0f, 18.0f, 2.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.61f, 0.0f, -1.15f, 0.43f, -1.29f, 1.04f)
                lineTo(16.4f, 4.0f)
                horizontalLineToRelative(-0.98f)
                curveToRelative(-0.61f, -0.04f, -1.16f, 0.32f, -1.35f, 0.88f)
                curveToRelative(-0.19f, 0.56f, 0.04f, 1.17f, 0.56f, 1.48f)
                lineToRelative(0.87f, 0.52f)
                lineTo(15.1f, 8.12f)
                curveToRelative(-0.23f, 0.58f, -0.04f, 1.25f, 0.45f, 1.62f)
                curveToRelative(0.5f, 0.37f, 1.17f, 0.35f, 1.64f, -0.06f)
                lineTo(18.0f, 8.98f)
                lineToRelative(0.81f, 0.7f)
                curveToRelative(0.47f, 0.4f, 1.15f, 0.43f, 1.64f, 0.06f)
                curveToRelative(0.5f, -0.37f, 0.68f, -1.04f, 0.45f, -1.62f)
                lineToRelative(-0.39f, -1.24f)
                lineToRelative(0.87f, -0.52f)
                curveTo(21.89f, 6.05f, 22.12f, 5.44f, 21.94f, 4.88f)
                close()
                moveTo(18.0f, 7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(19.0f, 6.55f, 18.55f, 7.0f, 18.0f, 7.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.1f, 17.9f)
                curveToRelative(0.53f, 0.53f, 1.27f, 0.69f, 1.94f, 0.5f)
                curveToRelative(-0.03f, -1.19f, 0.35f, -2.37f, 0.92f, -3.36f)
                curveToRelative(-1.0f, 0.57f, -2.17f, 0.95f, -3.36f, 0.92f)
                curveTo(5.41f, 16.63f, 5.58f, 17.37f, 6.1f, 17.9f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(9.65f, 11.55f)
                lineToRelative(1.61f, 0.66f)
                curveToRelative(0.25f, 0.1f, 0.44f, 0.3f, 0.54f, 0.54f)
                lineToRelative(0.66f, 1.61f)
                curveToRelative(0.75f, -0.78f, 0.74f, -2.01f, -0.03f, -2.78f)
                curveTo(11.66f, 10.8f, 10.43f, 10.8f, 9.65f, 11.55f)
                close()
            }
            materialPath {
                moveTo(14.86f, 12.0f)
                curveToRelative(-0.17f, -0.67f, -0.5f, -1.31f, -1.03f, -1.84f)
                curveTo(13.31f, 9.64f, 12.67f, 9.31f, 12.0f, 9.14f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(-1.01f, 0.01f, -2.02f, 0.39f, -2.79f, 1.16f)
                curveToRelative(-0.13f, 0.13f, -0.33f, 0.33f, -0.56f, 0.56f)
                lineToRelative(-1.53f, -0.63f)
                curveToRelative(-1.52f, -0.63f, -3.27f, 0.1f, -3.89f, 1.62f)
                curveToRelative(-0.6f, 1.46f, 0.05f, 3.11f, 1.44f, 3.8f)
                curveToRelative(-0.33f, 1.31f, 0.0f, 2.76f, 1.03f, 3.79f)
                curveToRelative(1.03f, 1.03f, 2.48f, 1.36f, 3.79f, 1.03f)
                curveToRelative(0.69f, 1.39f, 2.34f, 2.04f, 3.8f, 1.44f)
                curveToRelative(1.52f, -0.63f, 2.25f, -2.37f, 1.62f, -3.89f)
                lineToRelative(-0.63f, -1.53f)
                curveToRelative(0.23f, -0.23f, 0.43f, -0.43f, 0.56f, -0.56f)
                curveToRelative(0.77f, -0.77f, 1.16f, -1.78f, 1.16f, -2.79f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(14.86f)
                close()
                moveTo(4.58f, 13.8f)
                curveToRelative(-0.51f, -0.21f, -0.75f, -0.79f, -0.54f, -1.3f)
                curveToRelative(0.21f, -0.51f, 0.79f, -0.75f, 1.3f, -0.54f)
                lineToRelative(2.92f, 1.2f)
                curveTo(7.22f, 13.84f, 5.83f, 14.31f, 4.58f, 13.8f)
                close()
                moveTo(8.04f, 18.4f)
                curveToRelative(-0.67f, 0.19f, -1.41f, 0.02f, -1.94f, -0.5f)
                curveToRelative(-0.53f, -0.53f, -0.69f, -1.27f, -0.5f, -1.94f)
                curveToRelative(1.19f, 0.03f, 2.37f, -0.35f, 3.36f, -0.92f)
                curveTo(8.39f, 16.03f, 8.01f, 17.21f, 8.04f, 18.4f)
                close()
                moveTo(11.5f, 19.96f)
                curveToRelative(-0.51f, 0.21f, -1.09f, -0.03f, -1.3f, -0.54f)
                curveToRelative(-0.51f, -1.25f, -0.04f, -2.64f, 0.64f, -3.67f)
                lineToRelative(1.2f, 2.92f)
                curveTo(12.25f, 19.17f, 12.01f, 19.76f, 11.5f, 19.96f)
                close()
                moveTo(12.45f, 14.35f)
                lineToRelative(-0.66f, -1.61f)
                curveToRelative(-0.1f, -0.25f, -0.3f, -0.44f, -0.54f, -0.54f)
                lineToRelative(-1.61f, -0.66f)
                curveToRelative(0.78f, -0.75f, 2.01f, -0.74f, 2.78f, 0.03f)
                curveTo(13.2f, 12.34f, 13.2f, 13.57f, 12.45f, 14.35f)
                close()
            }
        }
        return _emojiNature!!
    }

private var _emojiNature: ImageVector? = null
