/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.MonochromePhotos: ImageVector
    get() {
        if (_monochromePhotos != null) {
            return _monochromePhotos!!
        }
        _monochromePhotos = materialIcon(name = "Sharp.MonochromePhotos") {
            materialPath {
                moveTo(22.0f, 5.0f)
                horizontalLineToRelative(-5.2f)
                lineTo(15.0f, 3.0f)
                lineTo(9.0f, 3.0f)
                lineTo(7.2f, 5.0f)
                lineTo(2.0f, 5.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(20.0f)
                lineTo(22.0f, 5.0f)
                close()
                moveTo(20.0f, 19.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(-2.8f, 0.0f, -5.0f, -2.2f, -5.0f, -5.0f)
                reflectiveCurveToRelative(2.2f, -5.0f, 5.0f, -5.0f)
                lineTo(12.0f, 7.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(12.0f)
                close()
                moveTo(17.0f, 13.0f)
                curveToRelative(0.0f, -2.8f, -2.2f, -5.0f, -5.0f, -5.0f)
                verticalLineToRelative(1.8f)
                curveToRelative(1.8f, 0.0f, 3.2f, 1.4f, 3.2f, 3.2f)
                reflectiveCurveToRelative(-1.4f, 3.2f, -3.2f, 3.2f)
                lineTo(12.0f, 18.0f)
                curveToRelative(2.8f, 0.0f, 5.0f, -2.2f, 5.0f, -5.0f)
                close()
                moveTo(8.8f, 13.0f)
                curveToRelative(0.0f, 1.8f, 1.4f, 3.2f, 3.2f, 3.2f)
                lineTo(12.0f, 9.8f)
                curveToRelative(-1.8f, 0.0f, -3.2f, 1.4f, -3.2f, 3.2f)
                close()
            }
        }
        return _monochromePhotos!!
    }

private var _monochromePhotos: ImageVector? = null
