/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Texture: ImageVector
    get() {
        if (_texture != null) {
            return _texture!!
        }
        _texture = materialIcon(name = "Filled.Texture") {
            materialPath {
                moveTo(19.51f, 3.08f)
                lineTo(3.08f, 19.51f)
                curveToRelative(0.09f, 0.34f, 0.27f, 0.65f, 0.51f, 0.9f)
                curveToRelative(0.25f, 0.24f, 0.56f, 0.42f, 0.9f, 0.51f)
                lineTo(20.93f, 4.49f)
                curveToRelative(-0.19f, -0.69f, -0.73f, -1.23f, -1.42f, -1.41f)
                close()
                moveTo(11.88f, 3.0f)
                lineTo(3.0f, 11.88f)
                verticalLineToRelative(2.83f)
                lineTo(14.71f, 3.0f)
                horizontalLineToRelative(-2.83f)
                close()
                moveTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(2.0f)
                lineToRelative(4.0f, -4.0f)
                lineTo(5.0f, 3.0f)
                close()
                moveTo(19.0f, 21.0f)
                curveToRelative(0.55f, 0.0f, 1.05f, -0.22f, 1.41f, -0.59f)
                curveToRelative(0.37f, -0.36f, 0.59f, -0.86f, 0.59f, -1.41f)
                verticalLineToRelative(-2.0f)
                lineToRelative(-4.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                close()
                moveTo(9.29f, 21.0f)
                horizontalLineToRelative(2.83f)
                lineTo(21.0f, 12.12f)
                lineTo(21.0f, 9.29f)
                lineTo(9.29f, 21.0f)
                close()
            }
        }
        return _texture!!
    }

private var _texture: ImageVector? = null
