/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.Sharp.AddToHomeScreen: ImageVector
    get() {
        if (_addToHomeScreen != null) {
            return _addToHomeScreen!!
        }
        _addToHomeScreen = materialIcon(name = "AutoMirrored.Sharp.AddToHomeScreen", autoMirror =
                true) {
            materialPath {
                moveTo(20.0f, 1.01f)
                lineTo(6.0f, 1.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(14.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(14.0f)
                verticalLineTo(1.01f)
                close()
                moveTo(10.0f, 15.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(8.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(3.59f)
                lineTo(3.0f, 15.59f)
                lineTo(4.41f, 17.0f)
                lineTo(10.0f, 11.41f)
                verticalLineTo(15.0f)
                close()
            }
        }
        return _addToHomeScreen!!
    }

private var _addToHomeScreen: ImageVector? = null
