/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.GroupOff: ImageVector
    get() {
        if (_groupOff != null) {
            return _groupOff!!
        }
        _groupOff = materialIcon(name = "TwoTone.GroupOff") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(10.99f, 8.16f)
                curveTo(11.0f, 8.11f, 11.0f, 8.06f, 11.0f, 8.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                curveTo(8.94f, 6.0f, 8.89f, 6.0f, 8.84f, 6.01f)
                lineTo(10.99f, 8.16f)
                close()
                moveTo(9.0f, 15.0f)
                curveToRelative(-2.7f, 0.0f, -5.8f, 1.29f, -6.0f, 2.01f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-0.17f)
                lineToRelative(-2.11f, -2.11f)
                curveTo(11.76f, 15.31f, 10.33f, 15.0f, 9.0f, 15.0f)
                close()
            }
            materialPath {
                moveTo(15.0f, 8.0f)
                curveToRelative(0.0f, -1.42f, -0.5f, -2.73f, -1.33f, -3.76f)
                curveTo(14.09f, 4.1f, 14.53f, 4.0f, 15.0f, 4.0f)
                curveToRelative(2.21f, 0.0f, 4.0f, 1.79f, 4.0f, 4.0f)
                reflectiveCurveToRelative(-1.79f, 4.0f, -4.0f, 4.0f)
                curveToRelative(-0.06f, 0.0f, -0.12f, 0.0f, -0.18f, 0.0f)
                lineToRelative(-0.77f, -0.77f)
                curveTo(14.65f, 10.29f, 15.0f, 9.18f, 15.0f, 8.0f)
                close()
                moveTo(22.83f, 20.0f)
                horizontalLineTo(23.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -2.18f, -3.58f, -3.47f, -6.34f, -3.87f)
                curveToRelative(1.1f, 0.75f, 1.95f, 1.71f, 2.23f, 2.94f)
                lineTo(22.83f, 20.0f)
                close()
                moveTo(9.0f, 6.0f)
                curveTo(8.94f, 6.0f, 8.89f, 6.0f, 8.84f, 6.01f)
                lineToRelative(-1.6f, -1.6f)
                curveTo(7.77f, 4.15f, 8.37f, 4.0f, 9.0f, 4.0f)
                curveToRelative(2.21f, 0.0f, 4.0f, 1.79f, 4.0f, 4.0f)
                curveToRelative(0.0f, 0.63f, -0.15f, 1.23f, -0.41f, 1.76f)
                lineToRelative(-1.6f, -1.6f)
                curveTo(11.0f, 8.11f, 11.0f, 8.06f, 11.0f, 8.0f)
                curveTo(11.0f, 6.9f, 10.1f, 6.0f, 9.0f, 6.0f)
                close()
                moveTo(9.17f, 12.0f)
                curveTo(9.11f, 12.0f, 9.06f, 12.0f, 9.0f, 12.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                curveToRelative(0.0f, -0.06f, 0.0f, -0.11f, 0.0f, -0.17f)
                lineTo(0.69f, 3.51f)
                lineTo(2.1f, 2.1f)
                lineToRelative(19.8f, 19.8f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(17.0f, 19.83f)
                verticalLineTo(20.0f)
                horizontalLineTo(1.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -2.66f, 5.33f, -4.0f, 8.0f, -4.0f)
                curveToRelative(0.37f, 0.0f, 0.8f, 0.03f, 1.25f, 0.08f)
                lineTo(9.17f, 12.0f)
                close()
                moveTo(9.0f, 15.0f)
                curveToRelative(-2.7f, 0.0f, -5.8f, 1.29f, -6.0f, 2.01f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-0.17f)
                lineToRelative(-2.11f, -2.11f)
                curveTo(11.76f, 15.31f, 10.33f, 15.0f, 9.0f, 15.0f)
                close()
            }
        }
        return _groupOff!!
    }

private var _groupOff: ImageVector? = null
