/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Chalet: ImageVector
    get() {
        if (_chalet != null) {
            return _chalet!!
        }
        _chalet = materialIcon(name = "TwoTone.Chalet") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(13.0f, 18.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, -3.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 3.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, -4.67f)
                lineToRelative(3.0f, -3.0f)
                lineToRelative(3.0f, 3.0f)
                close()
            }
            materialPath {
                moveTo(17.5f, 15.0f)
                lineTo(10.0f, 7.5f)
                lineTo(2.5f, 15.0f)
                lineToRelative(1.41f, 1.41f)
                lineTo(5.0f, 15.33f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(-4.67f)
                lineToRelative(1.09f, 1.09f)
                lineTo(17.5f, 15.0f)
                close()
                moveTo(13.0f, 18.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(3.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-4.67f)
                lineToRelative(3.0f, -3.0f)
                lineToRelative(3.0f, 3.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(22.0f, 7.5f)
                horizontalLineToRelative(-1.19f)
                lineToRelative(0.75f, 0.75f)
                lineToRelative(-0.71f, 0.71f)
                lineTo(19.39f, 7.5f)
                horizontalLineTo(18.5f)
                verticalLineToRelative(0.89f)
                lineToRelative(1.45f, 1.45f)
                lineToRelative(-0.71f, 0.71f)
                lineTo(18.5f, 9.81f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(9.81f)
                lineToRelative(-0.75f, 0.75f)
                lineToRelative(-0.71f, -0.71f)
                lineToRelative(1.45f, -1.45f)
                verticalLineTo(7.5f)
                horizontalLineToRelative(-0.89f)
                lineToRelative(-1.45f, 1.45f)
                lineToRelative(-0.71f, -0.71f)
                lineToRelative(0.75f, -0.75f)
                horizontalLineTo(14.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(1.19f)
                lineToRelative(-0.75f, -0.75f)
                lineToRelative(0.71f, -0.71f)
                lineToRelative(1.45f, 1.45f)
                horizontalLineToRelative(0.89f)
                verticalLineTo(5.61f)
                lineToRelative(-1.45f, -1.45f)
                lineToRelative(0.71f, -0.71f)
                lineToRelative(0.75f, 0.75f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.19f)
                lineToRelative(0.75f, -0.75f)
                lineToRelative(0.71f, 0.71f)
                lineTo(18.5f, 5.61f)
                verticalLineTo(6.5f)
                horizontalLineToRelative(0.89f)
                lineToRelative(1.45f, -1.45f)
                lineToRelative(0.71f, 0.71f)
                lineTo(20.81f, 6.5f)
                horizontalLineTo(22.0f)
                verticalLineTo(7.5f)
                close()
            }
        }
        return _chalet!!
    }

private var _chalet: ImageVector? = null
