/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.TimerOff: ImageVector
    get() {
        if (_timerOff != null) {
            return _timerOff!!
        }
        _timerOff = materialIcon(name = "Rounded.TimerOff") {
            materialPath {
                moveTo(10.0f, 3.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-4.0f)
                curveTo(9.45f, 1.0f, 9.0f, 1.45f, 9.0f, 2.0f)
                curveTo(9.0f, 2.55f, 9.45f, 3.0f, 10.0f, 3.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 8.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(1.17f)
                lineToRelative(6.98f, 6.98f)
                curveTo(20.63f, 15.91f, 21.0f, 14.5f, 21.0f, 13.0f)
                curveToRelative(0.0f, -2.12f, -0.74f, -4.07f, -1.97f, -5.61f)
                lineToRelative(0.75f, -0.75f)
                curveToRelative(0.38f, -0.38f, 0.39f, -1.01f, 0.0f, -1.4f)
                curveToRelative(0.0f, 0.0f, -0.01f, -0.01f, -0.01f, -0.01f)
                curveToRelative(-0.39f, -0.39f, -1.01f, -0.38f, -1.4f, 0.0f)
                lineToRelative(-0.75f, 0.75f)
                curveTo(16.07f, 4.74f, 14.12f, 4.0f, 12.0f, 4.0f)
                curveToRelative(-1.48f, 0.0f, -2.89f, 0.38f, -4.13f, 1.04f)
                lineToRelative(3.36f, 3.36f)
                curveTo(11.41f, 8.16f, 11.68f, 8.0f, 12.0f, 8.0f)
                close()
            }
            materialPath {
                moveTo(2.1f, 3.51f)
                lineTo(2.1f, 3.51f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(2.72f, 2.72f)
                curveTo(3.73f, 9.09f, 3.05f, 10.86f, 3.0f, 12.76f)
                curveTo(2.87f, 17.84f, 6.94f, 22.0f, 12.0f, 22.0f)
                curveToRelative(2.02f, 0.0f, 3.88f, -0.67f, 5.38f, -1.79f)
                lineToRelative(1.69f, 1.69f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(3.51f, 3.51f)
                curveTo(3.12f, 3.12f, 2.49f, 3.12f, 2.1f, 3.51f)
                close()
            }
        }
        return _timerOff!!
    }

private var _timerOff: ImageVector? = null
