/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SmokeFree: ImageVector
    get() {
        if (_smokeFree != null) {
            return _smokeFree!!
        }
        _smokeFree = materialIcon(name = "Rounded.SmokeFree") {
            materialPath {
                moveTo(20.5f, 13.0f)
                lineTo(22.0f, 13.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-1.5f)
                close()
                moveTo(18.0f, 13.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(3.0f)
                lineTo(18.0f, 16.0f)
                close()
                moveTo(17.0f, 14.5f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                horizontalLineToRelative(-0.84f)
                lineToRelative(2.18f, 2.18f)
                curveToRelative(0.1f, -0.21f, 0.16f, -0.44f, 0.16f, -0.68f)
                close()
                moveTo(18.96f, 2.35f)
                lineTo(19.0f, 2.35f)
                horizontalLineToRelative(-0.04f)
                close()
                moveTo(18.85f, 4.73f)
                curveToRelative(0.38f, -0.38f, 0.67f, -0.84f, 0.84f, -1.35f)
                curveToRelative(0.16f, -0.5f, -0.19f, -1.01f, -0.71f, -1.02f)
                curveToRelative(-0.34f, 0.01f, -0.61f, 0.25f, -0.72f, 0.58f)
                curveToRelative(-0.18f, 0.55f, -0.62f, 0.99f, -1.17f, 1.17f)
                curveToRelative(-0.34f, 0.11f, -0.59f, 0.39f, -0.59f, 0.74f)
                lineTo(16.5f, 5.0f)
                curveToRelative(0.0f, 0.37f, 0.27f, 0.69f, 0.64f, 0.75f)
                curveToRelative(1.93f, 0.31f, 3.36f, 2.0f, 3.36f, 4.02f)
                verticalLineToRelative(1.48f)
                curveToRelative(0.0f, 0.41f, 0.34f, 0.75f, 0.75f, 0.75f)
                reflectiveCurveToRelative(0.75f, -0.34f, 0.75f, -0.75f)
                lineTo(22.0f, 9.76f)
                curveToRelative(0.0f, -2.22f, -1.28f, -4.14f, -3.15f, -5.03f)
                close()
                moveTo(14.61f, 8.65f)
                horizontalLineToRelative(1.42f)
                curveToRelative(1.05f, 0.0f, 1.97f, 0.74f, 1.97f, 2.05f)
                verticalLineToRelative(0.55f)
                curveToRelative(0.0f, 0.41f, 0.33f, 0.75f, 0.75f, 0.75f)
                horizontalLineToRelative(0.01f)
                curveToRelative(0.41f, 0.0f, 0.75f, -0.33f, 0.75f, -0.75f)
                verticalLineToRelative(-0.89f)
                curveToRelative(0.0f, -1.81f, -1.6f, -3.16f, -3.47f, -3.16f)
                horizontalLineToRelative(-1.3f)
                curveToRelative(-1.02f, 0.0f, -1.94f, -0.73f, -2.07f, -1.75f)
                curveToRelative(-0.12f, -0.95f, 0.46f, -1.7f, 1.3f, -1.93f)
                curveToRelative(0.32f, -0.09f, 0.54f, -0.38f, 0.54f, -0.72f)
                curveToRelative(0.0f, -0.49f, -0.46f, -0.86f, -0.93f, -0.72f)
                curveToRelative(-1.42f, 0.41f, -2.45f, 1.73f, -2.42f, 3.28f)
                curveToRelative(0.02f, 1.85f, 1.61f, 3.29f, 3.45f, 3.29f)
                close()
                moveTo(4.12f, 5.29f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineTo(9.0f, 13.0f)
                lineTo(3.5f, 13.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, 0.67f, -1.5f, 1.5f)
                reflectiveCurveTo(2.67f, 16.0f, 3.5f, 16.0f)
                lineTo(12.0f, 16.0f)
                lineToRelative(6.29f, 6.29f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(4.12f, 5.29f)
                close()
            }
        }
        return _smokeFree!!
    }

private var _smokeFree: ImageVector? = null
