/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Sailing: ImageVector
    get() {
        if (_sailing != null) {
            return _sailing!!
        }
        _sailing = materialIcon(name = "Rounded.Sailing") {
            materialPath {
                moveTo(11.0f, 13.0f)
                verticalLineTo(3.59f)
                curveToRelative(0.0f, -0.49f, -0.63f, -0.69f, -0.91f, -0.29f)
                lineToRelative(-6.54f, 9.41f)
                curveToRelative(-0.23f, 0.33f, 0.01f, 0.79f, 0.41f, 0.79f)
                horizontalLineToRelative(6.54f)
                curveTo(10.78f, 13.5f, 11.0f, 13.28f, 11.0f, 13.0f)
                close()
                moveTo(20.99f, 12.98f)
                curveTo(20.72f, 7.07f, 15.9f, 2.32f, 13.4f, 1.23f)
                curveToRelative(-0.37f, -0.16f, -0.77f, 0.2f, -0.67f, 0.59f)
                curveToRelative(0.3f, 1.13f, 0.76f, 3.28f, 0.76f, 5.68f)
                curveToRelative(0.0f, 2.44f, -0.49f, 4.39f, -0.78f, 5.35f)
                curveToRelative(-0.1f, 0.32f, 0.14f, 0.65f, 0.48f, 0.65f)
                horizontalLineToRelative(7.28f)
                curveTo(20.76f, 13.5f, 21.0f, 13.26f, 20.99f, 12.98f)
                close()
                moveTo(20.62f, 15.0f)
                horizontalLineTo(3.38f)
                curveToRelative(-0.73f, 0.0f, -1.22f, 0.76f, -0.92f, 1.42f)
                curveToRelative(0.43f, 0.92f, 1.07f, 1.71f, 1.86f, 2.31f)
                curveToRelative(0.38f, -0.16f, 0.74f, -0.38f, 1.06f, -0.63f)
                curveToRelative(0.35f, -0.29f, 0.87f, -0.29f, 1.23f, 0.0f)
                curveTo(7.28f, 18.63f, 8.1f, 19.0f, 9.0f, 19.0f)
                curveToRelative(0.9f, 0.0f, 1.72f, -0.37f, 2.39f, -0.91f)
                curveToRelative(0.35f, -0.28f, 0.87f, -0.28f, 1.22f, 0.0f)
                curveTo(13.28f, 18.63f, 14.1f, 19.0f, 15.0f, 19.0f)
                curveToRelative(0.9f, 0.0f, 1.72f, -0.37f, 2.39f, -0.91f)
                curveToRelative(0.35f, -0.29f, 0.87f, -0.28f, 1.23f, 0.0f)
                curveToRelative(0.32f, 0.26f, 0.67f, 0.48f, 1.06f, 0.63f)
                curveToRelative(0.79f, -0.6f, 1.43f, -1.39f, 1.86f, -2.31f)
                curveTo(21.84f, 15.76f, 21.35f, 15.0f, 20.62f, 15.0f)
                close()
                moveTo(22.0f, 22.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.87f, 0.0f, -1.73f, -0.24f, -2.53f, -0.7f)
                curveToRelative(-0.29f, -0.16f, -0.65f, -0.17f, -0.94f, 0.0f)
                curveToRelative(-1.59f, 0.9f, -3.47f, 0.9f, -5.06f, 0.0f)
                curveToRelative(-0.29f, -0.16f, -0.65f, -0.16f, -0.94f, 0.0f)
                curveToRelative(-1.59f, 0.9f, -3.47f, 0.9f, -5.06f, 0.0f)
                curveToRelative(-0.29f, -0.16f, -0.65f, -0.16f, -0.94f, 0.0f)
                curveTo(4.73f, 20.76f, 3.87f, 21.0f, 3.0f, 21.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(1.15f, 0.0f, 2.3f, -0.31f, 3.33f, -0.94f)
                curveToRelative(1.66f, 1.11f, 3.78f, 1.01f, 5.58f, 0.14f)
                curveToRelative(1.91f, 1.05f, 4.17f, 1.07f, 6.09f, 0.05f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.95f, 0.5f, 1.97f, 0.75f, 3.0f, 0.75f)
                horizontalLineToRelative(0.0f)
                curveTo(21.55f, 23.0f, 22.0f, 22.55f, 22.0f, 22.0f)
                close()
            }
        }
        return _sailing!!
    }

private var _sailing: ImageVector? = null
