/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Polyline: ImageVector
    get() {
        if (_polyline != null) {
            return _polyline!!
        }
        _polyline = materialIcon(name = "Rounded.Polyline") {
            materialPath {
                moveTo(10.04f, 6.85f)
                lineTo(7.3f, 10.0f)
                horizontalLineTo(4.5f)
                curveTo(3.67f, 10.0f, 3.0f, 10.67f, 3.0f, 11.5f)
                verticalLineToRelative(3.0f)
                curveTo(3.0f, 15.33f, 3.67f, 16.0f, 4.5f, 16.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.14f, 0.0f, 0.27f, -0.02f, 0.39f, -0.05f)
                lineTo(15.0f, 19.5f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.83f, 0.67f, 1.5f, 1.5f, 1.5f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-0.75f, 0.0f, -1.37f, 0.55f, -1.48f, 1.27f)
                lineTo(9.0f, 14.26f)
                verticalLineTo(11.5f)
                curveToRelative(0.0f, -0.12f, -0.01f, -0.24f, -0.04f, -0.36f)
                lineTo(11.7f, 8.0f)
                horizontalLineToRelative(2.8f)
                curveTo(15.33f, 8.0f, 16.0f, 7.33f, 16.0f, 6.5f)
                verticalLineToRelative(-3.0f)
                curveTo(16.0f, 2.67f, 15.33f, 2.0f, 14.5f, 2.0f)
                horizontalLineToRelative(-3.0f)
                curveTo(10.67f, 2.0f, 10.0f, 2.67f, 10.0f, 3.5f)
                verticalLineToRelative(3.0f)
                curveTo(10.0f, 6.62f, 10.01f, 6.74f, 10.04f, 6.85f)
                close()
            }
        }
        return _polyline!!
    }

private var _polyline: ImageVector? = null
