/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.PinDrop: ImageVector
    get() {
        if (_pinDrop != null) {
            return _pinDrop!!
        }
        _pinDrop = materialIcon(name = "Rounded.PinDrop") {
            materialPath {
                moveTo(6.0f, 20.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(6.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveTo(5.45f, 20.0f, 6.0f, 20.0f)
                close()
                moveTo(12.0f, 7.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(13.1f, 7.0f, 12.0f, 7.0f)
                close()
                moveTo(12.0f, 2.0f)
                curveToRelative(3.27f, 0.0f, 7.0f, 2.46f, 7.0f, 7.15f)
                curveToRelative(0.0f, 2.98f, -2.13f, 6.12f, -6.39f, 9.39f)
                curveToRelative(-0.36f, 0.28f, -0.86f, 0.28f, -1.22f, 0.0f)
                curveTo(7.13f, 15.26f, 5.0f, 12.13f, 5.0f, 9.15f)
                curveTo(5.0f, 4.46f, 8.73f, 2.0f, 12.0f, 2.0f)
                close()
            }
        }
        return _pinDrop!!
    }

private var _pinDrop: ImageVector? = null
