/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.NearMeDisabled: ImageVector
    get() {
        if (_nearMeDisabled != null) {
            return _nearMeDisabled!!
        }
        _nearMeDisabled = materialIcon(name = "Rounded.NearMeDisabled") {
            materialPath {
                moveTo(12.0f, 6.34f)
                lineToRelative(6.95f, -2.58f)
                curveToRelative(0.8f, -0.3f, 1.58f, 0.48f, 1.29f, 1.29f)
                lineTo(17.66f, 12.0f)
                lineTo(12.0f, 6.34f)
                close()
                moveTo(21.9f, 19.07f)
                lineTo(4.93f, 2.1f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(4.36f, 4.36f)
                lineToRelative(-4.2f, 1.56f)
                curveTo(3.27f, 9.59f, 3.0f, 9.97f, 3.0f, 10.4f)
                curveToRelative(0.0f, 0.42f, 0.26f, 0.8f, 0.65f, 0.96f)
                lineToRelative(6.42f, 2.57f)
                lineToRelative(2.57f, 6.42f)
                curveTo(12.8f, 20.74f, 13.18f, 21.0f, 13.6f, 21.0f)
                curveToRelative(0.43f, 0.0f, 0.82f, -0.27f, 0.97f, -0.67f)
                lineToRelative(1.56f, -4.2f)
                lineToRelative(4.36f, 4.36f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveTo(22.29f, 20.09f, 22.29f, 19.46f, 21.9f, 19.07f)
                close()
            }
        }
        return _nearMeDisabled!!
    }

private var _nearMeDisabled: ImageVector? = null
