/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AddLocation: ImageVector
    get() {
        if (_addLocation != null) {
            return _addLocation!!
        }
        _addLocation = materialIcon(name = "Rounded.AddLocation") {
            materialPath {
                moveTo(13.0f, 7.0f)
                curveToRelative(0.0f, -0.55f, -0.44f, -1.0f, -1.0f, -1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.44f, -1.0f, 1.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(9.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.44f, -1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, 0.44f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.55f, 0.44f, 1.0f, 1.0f, 1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.44f, 1.0f, -1.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.44f, 1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, -0.44f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(12.0f, 2.0f)
                curveToRelative(4.2f, 0.0f, 8.0f, 3.22f, 8.0f, 8.2f)
                curveToRelative(0.0f, 3.18f, -2.45f, 6.92f, -7.34f, 11.23f)
                curveToRelative(-0.38f, 0.33f, -0.95f, 0.33f, -1.33f, 0.0f)
                curveTo(6.45f, 17.12f, 4.0f, 13.38f, 4.0f, 10.2f)
                curveTo(4.0f, 5.22f, 7.8f, 2.0f, 12.0f, 2.0f)
                close()
            }
        }
        return _addLocation!!
    }

private var _addLocation: ImageVector? = null
