/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ShieldMoon: ImageVector
    get() {
        if (_shieldMoon != null) {
            return _shieldMoon!!
        }
        _shieldMoon = materialIcon(name = "Outlined.ShieldMoon") {
            materialPath {
                moveTo(12.0f, 2.0f)
                lineTo(4.0f, 5.0f)
                verticalLineToRelative(6.09f)
                curveToRelative(0.0f, 5.05f, 3.41f, 9.76f, 8.0f, 10.91f)
                curveToRelative(4.59f, -1.15f, 8.0f, -5.86f, 8.0f, -10.91f)
                verticalLineTo(5.0f)
                lineTo(12.0f, 2.0f)
                close()
                moveTo(18.0f, 11.09f)
                curveToRelative(0.0f, 4.0f, -2.55f, 7.7f, -6.0f, 8.83f)
                curveToRelative(-3.45f, -1.13f, -6.0f, -4.82f, -6.0f, -8.83f)
                verticalLineToRelative(-4.7f)
                lineToRelative(6.0f, -2.25f)
                lineToRelative(6.0f, 2.25f)
                verticalLineTo(11.09f)
                close()
            }
            materialPath {
                moveTo(9.01f, 14.33f)
                curveToRelative(1.75f, 2.17f, 5.12f, 2.24f, 6.96f, 0.07f)
                curveToRelative(0.23f, -0.27f, 0.08f, -0.68f, -0.26f, -0.74f)
                curveToRelative(-1.29f, -0.21f, -2.48f, -0.98f, -3.18f, -2.2f)
                curveToRelative(-0.71f, -1.22f, -0.78f, -2.63f, -0.32f, -3.86f)
                curveToRelative(0.12f, -0.33f, -0.16f, -0.66f, -0.51f, -0.6f)
                curveTo(8.36f, 7.62f, 6.81f, 11.61f, 9.01f, 14.33f)
                close()
            }
        }
        return _shieldMoon!!
    }

private var _shieldMoon: ImageVector? = null
