/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.RawOn: ImageVector
    get() {
        if (_rawOn != null) {
            return _rawOn!!
        }
        _rawOn = materialIcon(name = "Filled.RawOn") {
            materialPath {
                moveTo(6.5f, 9.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.1f)
                lineToRelative(0.9f, 2.0f)
                horizontalLineTo(8.0f)
                lineToRelative(-0.9f, -2.1f)
                curveTo(7.6f, 12.6f, 8.0f, 12.1f, 8.0f, 11.5f)
                verticalLineToRelative(-1.0f)
                curveTo(8.0f, 9.7f, 7.3f, 9.0f, 6.5f, 9.0f)
                close()
                moveTo(6.5f, 11.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(11.5f)
                close()
            }
            materialPath {
                moveTo(10.25f, 9.0f)
                lineToRelative(-1.5f, 6.0f)
                horizontalLineToRelative(1.5f)
                lineToRelative(0.38f, -1.5f)
                horizontalLineToRelative(1.75f)
                lineToRelative(0.37f, 1.5f)
                horizontalLineToRelative(1.5f)
                lineToRelative(-1.5f, -6.0f)
                horizontalLineTo(10.25f)
                close()
                moveTo(11.0f, 12.0f)
                lineToRelative(0.25f, -1.0f)
                horizontalLineToRelative(0.5f)
                lineTo(12.0f, 12.0f)
                horizontalLineTo(11.0f)
                close()
            }
            materialPath {
                moveTo(19.98f, 9.0f)
                lineToRelative(-0.74f, 3.0f)
                lineToRelative(-0.74f, -3.0f)
                lineToRelative(-1.52f, 0.0f)
                lineToRelative(-0.74f, 3.0f)
                lineToRelative(-0.74f, -3.0f)
                lineToRelative(-1.5f, 0.0f)
                lineToRelative(1.5f, 6.0f)
                lineToRelative(1.48f, 0.0f)
                lineToRelative(0.76f, -3.04f)
                lineToRelative(0.76f, 3.04f)
                lineToRelative(1.48f, 0.0f)
                lineToRelative(1.5f, -6.0f)
                close()
            }
        }
        return _rawOn!!
    }

private var _rawOn: ImageVector? = null
