/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Handshake: ImageVector
    get() {
        if (_handshake != null) {
            return _handshake!!
        }
        _handshake = materialIcon(name = "Filled.Handshake") {
            materialPath {
                moveTo(16.48f, 10.41f)
                curveToRelative(-0.39f, 0.39f, -1.04f, 0.39f, -1.43f, 0.0f)
                lineToRelative(-4.47f, -4.46f)
                lineToRelative(-7.05f, 7.04f)
                lineToRelative(-0.66f, -0.63f)
                curveToRelative(-1.17f, -1.17f, -1.17f, -3.07f, 0.0f, -4.24f)
                lineToRelative(4.24f, -4.24f)
                curveToRelative(1.17f, -1.17f, 3.07f, -1.17f, 4.24f, 0.0f)
                lineTo(16.48f, 9.0f)
                curveTo(16.87f, 9.39f, 16.87f, 10.02f, 16.48f, 10.41f)
                close()
                moveTo(17.18f, 8.29f)
                curveToRelative(0.78f, 0.78f, 0.78f, 2.05f, 0.0f, 2.83f)
                curveToRelative(-1.27f, 1.27f, -2.61f, 0.22f, -2.83f, 0.0f)
                lineToRelative(-3.76f, -3.76f)
                lineToRelative(-5.57f, 5.57f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.42f, 0.0f)
                lineToRelative(4.62f, -4.62f)
                lineToRelative(0.71f, 0.71f)
                lineToRelative(-4.62f, 4.62f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.42f, 0.0f)
                lineToRelative(4.62f, -4.62f)
                lineToRelative(0.71f, 0.71f)
                lineToRelative(-4.62f, 4.62f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(4.62f, -4.62f)
                lineToRelative(0.71f, 0.71f)
                lineToRelative(-4.62f, 4.62f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(8.32f, -8.34f)
                curveToRelative(1.17f, -1.17f, 1.17f, -3.07f, 0.0f, -4.24f)
                lineToRelative(-4.24f, -4.24f)
                curveToRelative(-1.15f, -1.15f, -3.01f, -1.17f, -4.18f, -0.06f)
                lineTo(17.18f, 8.29f)
                close()
            }
        }
        return _handshake!!
    }

private var _handshake: ImageVector? = null
