/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Woman2: ImageVector
    get() {
        if (_woman2 != null) {
            return _woman2!!
        }
        _woman2 = materialIcon(name = "Rounded.Woman2") {
            materialPath {
                moveTo(13.94f, 8.31f)
                curveToRelative(-0.38f, -0.96f, -1.42f, -1.52f, -2.48f, -1.24f)
                curveToRelative(-0.66f, 0.17f, -1.18f, 0.7f, -1.43f, 1.34f)
                lineToRelative(-2.48f, 6.22f)
                curveTo(7.28f, 15.29f, 7.77f, 16.0f, 8.47f, 16.0f)
                horizontalLineToRelative(2.03f)
                verticalLineToRelative(5.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(2.03f)
                curveToRelative(0.71f, 0.0f, 1.19f, -0.71f, 0.93f, -1.37f)
                lineTo(13.94f, 8.31f)
                close()
            }
            materialPath {
                moveTo(12.0f, 4.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
        }
        return _woman2!!
    }

private var _woman2: ImageVector? = null
