/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.CleanHands: ImageVector
    get() {
        if (_cleanHands != null) {
            return _cleanHands!!
        }
        _cleanHands = materialIcon(name = "Rounded.CleanHands") {
            materialPath {
                moveTo(14.99f, 7.0f)
                lineToRelative(1.37f, -0.63f)
                lineTo(16.99f, 5.0f)
                lineToRelative(0.63f, 1.37f)
                lineTo(18.99f, 7.0f)
                lineToRelative(-1.37f, 0.63f)
                lineTo(16.99f, 9.0f)
                lineToRelative(-0.63f, -1.37f)
                lineTo(14.99f, 7.0f)
                close()
                moveTo(20.0f, 14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                curveToRelative(0.0f, -0.78f, -0.99f, -2.44f, -1.58f, -3.36f)
                curveToRelative(-0.2f, -0.31f, -0.64f, -0.31f, -0.84f, 0.0f)
                curveTo(18.99f, 9.56f, 18.0f, 11.22f, 18.0f, 12.0f)
                curveTo(18.0f, 13.1f, 18.9f, 14.0f, 20.0f, 14.0f)
                close()
                moveTo(9.24f, 9.5f)
                lineTo(15.0f, 11.65f)
                verticalLineTo(11.0f)
                curveToRelative(0.0f, -2.42f, -1.72f, -4.44f, -4.0f, -4.9f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.35f, 0.0f, 0.68f, 0.06f, 1.0f, 0.18f)
                curveToRelative(0.37f, 0.13f, 0.78f, 0.05f, 1.05f, -0.22f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.51f, -0.51f, 0.34f, -1.39f, -0.33f, -1.64f)
                curveTo(14.19f, 2.11f, 13.61f, 2.0f, 13.0f, 2.0f)
                horizontalLineTo(8.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(2.11f)
                curveTo(7.22f, 6.48f, 5.8f, 7.79f, 5.25f, 9.5f)
                horizontalLineTo(9.24f)
                close()
                moveTo(3.0f, 11.0f)
                lineTo(3.0f, 11.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(7.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-7.0f)
                curveTo(5.0f, 11.9f, 4.1f, 11.0f, 3.0f, 11.0f)
                close()
                moveTo(19.99f, 17.0f)
                horizontalLineToRelative(-6.83f)
                curveToRelative(-0.11f, 0.0f, -0.22f, -0.02f, -0.33f, -0.06f)
                lineToRelative(-1.47f, -0.51f)
                curveToRelative(-0.26f, -0.09f, -0.39f, -0.37f, -0.3f, -0.63f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.09f, -0.26f, 0.38f, -0.4f, 0.64f, -0.3f)
                lineToRelative(1.12f, 0.43f)
                curveToRelative(0.11f, 0.04f, 0.24f, 0.07f, 0.36f, 0.07f)
                horizontalLineToRelative(2.63f)
                curveToRelative(0.65f, 0.0f, 1.18f, -0.53f, 1.18f, -1.18f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.49f, -0.31f, -0.93f, -0.77f, -1.11f)
                lineTo(9.3f, 11.13f)
                curveTo(9.08f, 11.04f, 8.84f, 11.0f, 8.6f, 11.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(9.02f)
                lineToRelative(6.37f, 1.81f)
                curveToRelative(0.41f, 0.12f, 0.85f, 0.1f, 1.25f, -0.05f)
                lineTo(22.0f, 19.0f)
                lineToRelative(0.0f, 0.0f)
                curveTo(22.0f, 17.89f, 21.1f, 17.0f, 19.99f, 17.0f)
                close()
            }
        }
        return _cleanHands!!
    }

private var _cleanHands: ImageVector? = null
