/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.NoMeetingRoom: ImageVector
    get() {
        if (_noMeetingRoom != null) {
            return _noMeetingRoom!!
        }
        _noMeetingRoom = materialIcon(name = "TwoTone.NoMeetingRoom") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 5.0f)
                horizontalLineTo(8.12f)
                lineTo(12.0f, 8.88f)
                verticalLineTo(6.0f)
                close()
                moveTo(7.0f, 19.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(-4.46f)
                lineToRelative(-5.0f, -5.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 5.0f)
                verticalLineToRelative(3.88f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(7.88f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(6.12f)
                lineToRelative(2.0f, 2.0f)
                close()
                moveTo(2.41f, 2.13f)
                lineTo(1.0f, 3.54f)
                lineToRelative(4.0f, 4.0f)
                verticalLineTo(19.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(11.0f)
                verticalLineToRelative(-4.46f)
                lineTo(20.46f, 23.0f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.41f, 2.13f)
                close()
                moveTo(12.0f, 19.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(9.54f)
                lineToRelative(5.0f, 5.0f)
                verticalLineTo(19.0f)
                close()
            }
        }
        return _noMeetingRoom!!
    }

private var _noMeetingRoom: ImageVector? = null
