/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Man4: ImageVector
    get() {
        if (_man4 != null) {
            return _man4!!
        }
        _man4 = materialIcon(name = "TwoTone.Man4") {
            materialPath {
                moveTo(13.75f, 7.0f)
                horizontalLineToRelative(-3.5f)
                curveTo(9.04f, 7.0f, 8.11f, 8.07f, 8.27f, 9.26f)
                lineTo(10.0f, 22.0f)
                horizontalLineToRelative(4.0f)
                lineToRelative(1.73f, -12.74f)
                curveTo(15.89f, 8.07f, 14.96f, 7.0f, 13.75f, 7.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 4.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
        }
        return _man4!!
    }

private var _man4: ImageVector? = null
