/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LocalPizza: ImageVector
    get() {
        if (_localPizza != null) {
            return _localPizza!!
        }
        _localPizza = materialIcon(name = "Rounded.LocalPizza") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(9.01f, 2.0f, 6.28f, 3.08f, 4.17f, 4.88f)
                curveToRelative(-0.71f, 0.61f, -0.86f, 1.65f, -0.4f, 2.46f)
                lineToRelative(7.36f, 13.11f)
                curveToRelative(0.38f, 0.68f, 1.36f, 0.68f, 1.74f, 0.0f)
                lineToRelative(7.36f, -13.11f)
                curveToRelative(0.46f, -0.81f, 0.31f, -1.86f, -0.4f, -2.46f)
                curveTo(17.73f, 3.09f, 14.99f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(7.0f, 7.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                close()
                moveTo(12.0f, 15.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                close()
            }
        }
        return _localPizza!!
    }

private var _localPizza: ImageVector? = null
