/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LeakRemove: ImageVector
    get() {
        if (_leakRemove != null) {
            return _leakRemove!!
        }
        _leakRemove = materialIcon(name = "Rounded.LeakRemove") {
            materialPath {
                moveTo(20.12f, 12.04f)
                curveToRelative(0.5f, -0.05f, 0.88f, -0.48f, 0.88f, -0.99f)
                curveToRelative(0.0f, -0.59f, -0.51f, -1.06f, -1.1f, -1.0f)
                curveToRelative(-1.5f, 0.15f, -2.9f, 0.61f, -4.16f, 1.3f)
                lineToRelative(1.48f, 1.48f)
                curveToRelative(0.9f, -0.41f, 1.87f, -0.69f, 2.9f, -0.79f)
                close()
                moveTo(21.0f, 15.09f)
                curveToRelative(0.0f, -0.61f, -0.54f, -1.09f, -1.14f, -1.0f)
                curveToRelative(-0.38f, 0.06f, -0.75f, 0.16f, -1.11f, 0.28f)
                lineToRelative(1.62f, 1.62f)
                curveToRelative(0.37f, -0.15f, 0.63f, -0.49f, 0.63f, -0.9f)
                close()
                moveTo(13.97f, 4.14f)
                curveToRelative(0.06f, -0.59f, -0.4f, -1.11f, -1.0f, -1.11f)
                curveToRelative(-0.5f, 0.0f, -0.94f, 0.37f, -0.99f, 0.87f)
                curveToRelative(-0.1f, 1.03f, -0.38f, 2.01f, -0.79f, 2.91f)
                lineToRelative(1.48f, 1.48f)
                curveToRelative(0.69f, -1.26f, 1.15f, -2.66f, 1.3f, -4.15f)
                close()
                moveTo(9.93f, 4.16f)
                curveToRelative(0.1f, -0.6f, -0.39f, -1.14f, -1.0f, -1.14f)
                curveToRelative(-0.41f, 0.0f, -0.75f, 0.26f, -0.9f, 0.62f)
                lineToRelative(1.62f, 1.62f)
                curveToRelative(0.13f, -0.35f, 0.22f, -0.72f, 0.28f, -1.1f)
                close()
                moveTo(20.44f, 18.88f)
                lineTo(5.12f, 3.56f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(2.15f, 2.15f)
                curveToRelative(-0.59f, 0.41f, -1.26f, 0.7f, -1.99f, 0.82f)
                curveToRelative(-0.48f, 0.1f, -0.84f, 0.5f, -0.84f, 1.0f)
                curveToRelative(0.0f, 0.61f, 0.54f, 1.09f, 1.14f, 1.0f)
                curveToRelative(1.17f, -0.19f, 2.23f, -0.68f, 3.13f, -1.37f)
                lineTo(8.73f, 10.0f)
                curveToRelative(-1.34f, 1.1f, -3.0f, 1.82f, -4.81f, 1.99f)
                curveToRelative(-0.5f, 0.05f, -0.88f, 0.48f, -0.88f, 0.99f)
                curveToRelative(0.0f, 0.59f, 0.51f, 1.06f, 1.1f, 1.0f)
                curveToRelative(2.28f, -0.23f, 4.36f, -1.15f, 6.01f, -2.56f)
                lineToRelative(2.48f, 2.48f)
                curveToRelative(-1.4f, 1.65f, -2.33f, 3.72f, -2.56f, 6.0f)
                curveToRelative(-0.06f, 0.59f, 0.4f, 1.11f, 1.0f, 1.11f)
                curveToRelative(0.5f, 0.0f, 0.94f, -0.37f, 0.99f, -0.87f)
                curveToRelative(0.18f, -1.82f, 0.9f, -3.48f, 1.99f, -4.82f)
                lineToRelative(1.43f, 1.43f)
                curveToRelative(-0.69f, 0.9f, -1.18f, 1.96f, -1.37f, 3.13f)
                curveToRelative(-0.1f, 0.6f, 0.39f, 1.14f, 1.0f, 1.14f)
                curveToRelative(0.49f, 0.0f, 0.9f, -0.36f, 0.98f, -0.85f)
                curveToRelative(0.12f, -0.73f, 0.42f, -1.4f, 0.82f, -1.99f)
                lineToRelative(2.13f, 2.13f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.38f, -0.41f, 0.38f, -1.04f, -0.01f, -1.43f)
                close()
            }
        }
        return _leakRemove!!
    }

private var _leakRemove: ImageVector? = null
