/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FindReplace: ImageVector
    get() {
        if (_findReplace != null) {
            return _findReplace!!
        }
        _findReplace = materialIcon(name = "Rounded.FindReplace") {
            materialPath {
                moveTo(11.0f, 6.0f)
                curveToRelative(1.38f, 0.0f, 2.63f, 0.56f, 3.54f, 1.46f)
                lineToRelative(-1.69f, 1.69f)
                curveToRelative(-0.31f, 0.31f, -0.09f, 0.85f, 0.36f, 0.85f)
                horizontalLineToRelative(4.29f)
                curveToRelative(0.28f, 0.0f, 0.5f, -0.22f, 0.5f, -0.5f)
                lineTo(18.0f, 5.21f)
                curveToRelative(0.0f, -0.45f, -0.54f, -0.67f, -0.85f, -0.35f)
                lineToRelative(-1.2f, 1.2f)
                curveTo(14.68f, 4.78f, 12.93f, 4.0f, 11.0f, 4.0f)
                curveTo(7.96f, 4.0f, 5.38f, 5.94f, 4.42f, 8.64f)
                curveToRelative(-0.24f, 0.66f, 0.23f, 1.36f, 0.93f, 1.36f)
                curveToRelative(0.42f, 0.0f, 0.79f, -0.26f, 0.93f, -0.66f)
                curveTo(6.96f, 7.4f, 8.82f, 6.0f, 11.0f, 6.0f)
                close()
                moveTo(16.64f, 15.14f)
                curveToRelative(0.4f, -0.54f, 0.72f, -1.15f, 0.95f, -1.8f)
                curveToRelative(0.23f, -0.65f, -0.25f, -1.34f, -0.94f, -1.34f)
                curveToRelative(-0.42f, 0.0f, -0.79f, 0.26f, -0.93f, 0.66f)
                curveTo(15.04f, 14.6f, 13.18f, 16.0f, 11.0f, 16.0f)
                curveToRelative(-1.38f, 0.0f, -2.63f, -0.56f, -3.54f, -1.46f)
                lineToRelative(1.69f, -1.69f)
                curveToRelative(0.31f, -0.31f, 0.09f, -0.85f, -0.36f, -0.85f)
                lineTo(4.5f, 12.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                verticalLineToRelative(4.29f)
                curveToRelative(0.0f, 0.45f, 0.54f, 0.67f, 0.85f, 0.35f)
                lineToRelative(1.2f, -1.2f)
                curveTo(7.32f, 17.22f, 9.07f, 18.0f, 11.0f, 18.0f)
                curveToRelative(1.55f, 0.0f, 2.98f, -0.51f, 4.14f, -1.36f)
                lineToRelative(4.11f, 4.11f)
                curveToRelative(0.41f, 0.41f, 1.08f, 0.41f, 1.49f, 0.0f)
                curveToRelative(0.41f, -0.41f, 0.41f, -1.08f, 0.0f, -1.49f)
                lineToRelative(-4.1f, -4.12f)
                close()
            }
        }
        return _findReplace!!
    }

private var _findReplace: ImageVector? = null
