/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Deck: ImageVector
    get() {
        if (_deck != null) {
            return _deck!!
        }
        _deck = materialIcon(name = "Rounded.Deck") {
            materialPath {
                moveTo(20.41f, 9.0f)
                curveToRelative(0.49f, 0.0f, 0.69f, -0.63f, 0.29f, -0.91f)
                lineTo(13.15f, 2.8f)
                curveToRelative(-0.69f, -0.48f, -1.61f, -0.48f, -2.29f, 0.0f)
                lineTo(3.3f, 8.09f)
                curveTo(2.9f, 8.37f, 3.1f, 9.0f, 3.59f, 9.0f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(9.0f)
                horizontalLineTo(20.41f)
                close()
            }
            materialPath {
                moveTo(8.0f, 16.0f)
                horizontalLineTo(4.9f)
                lineToRelative(-0.57f, -3.02f)
                curveToRelative(-0.1f, -0.54f, -0.62f, -0.9f, -1.17f, -0.8f)
                curveToRelative(-0.54f, 0.1f, -0.9f, 0.62f, -0.8f, 1.17f)
                lineTo(3.0f, 16.74f)
                verticalLineTo(21.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.01f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.44f, 1.0f, -0.99f)
                lineTo(5.02f, 18.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                curveTo(9.0f, 16.45f, 8.55f, 16.0f, 8.0f, 16.0f)
                close()
            }
            materialPath {
                moveTo(20.84f, 12.18f)
                curveToRelative(-0.54f, -0.1f, -1.06f, 0.26f, -1.17f, 0.8f)
                lineTo(19.1f, 16.0f)
                horizontalLineTo(16.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(1.98f)
                lineToRelative(0.02f, 3.01f)
                curveToRelative(0.0f, 0.55f, 0.45f, 0.99f, 1.0f, 0.99f)
                horizontalLineTo(20.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-4.26f)
                lineToRelative(0.64f, -3.39f)
                curveTo(21.74f, 12.81f, 21.38f, 12.28f, 20.84f, 12.18f)
                close()
            }
        }
        return _deck!!
    }

private var _deck: ImageVector? = null
