/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ConnectWithoutContact: ImageVector
    get() {
        if (_connectWithoutContact != null) {
            return _connectWithoutContact!!
        }
        _connectWithoutContact = materialIcon(name = "Rounded.ConnectWithoutContact") {
            materialPath {
                moveTo(7.0f, 4.0f)
                curveToRelative(0.0f, -1.11f, -0.89f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveTo(3.0f, 2.89f, 3.0f, 4.0f)
                reflectiveCurveToRelative(0.89f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveTo(7.0f, 5.11f, 7.0f, 4.0f)
                close()
                moveTo(10.19f, 4.5f)
                lineTo(10.19f, 4.5f)
                curveToRelative(-0.41f, 0.0f, -0.76f, 0.25f, -0.92f, 0.63f)
                curveTo(8.83f, 6.23f, 7.76f, 7.0f, 6.5f, 7.0f)
                horizontalLineToRelative(-3.0f)
                curveTo(2.67f, 7.0f, 2.0f, 7.67f, 2.0f, 8.5f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(8.74f)
                curveToRelative(1.43f, -0.45f, 2.58f, -1.53f, 3.12f, -2.91f)
                curveTo(11.38f, 5.19f, 10.88f, 4.5f, 10.19f, 4.5f)
                close()
                moveTo(19.0f, 17.0f)
                curveToRelative(1.11f, 0.0f, 2.0f, -0.89f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.89f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.89f, -2.0f, 2.0f)
                reflectiveCurveTo(17.89f, 17.0f, 19.0f, 17.0f)
                close()
                moveTo(20.5f, 18.0f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-1.26f, 0.0f, -2.33f, -0.77f, -2.77f, -1.87f)
                curveToRelative(-0.15f, -0.38f, -0.51f, -0.63f, -0.92f, -0.63f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.69f, 0.0f, -1.19f, 0.69f, -0.94f, 1.33f)
                curveToRelative(0.55f, 1.38f, 1.69f, 2.46f, 3.12f, 2.91f)
                verticalLineTo(22.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-2.5f)
                curveTo(22.0f, 18.67f, 21.33f, 18.0f, 20.5f, 18.0f)
                close()
                moveTo(17.25f, 11.09f)
                curveToRelative(0.0f, 0.0f, 0.0f, -0.01f, 0.01f, 0.0f)
                curveToRelative(-1.06f, 0.27f, -1.9f, 1.11f, -2.17f, 2.17f)
                curveToRelative(0.0f, 0.0f, 0.0f, -0.01f, 0.0f, -0.01f)
                curveTo(14.98f, 13.68f, 14.58f, 14.0f, 14.11f, 14.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.05f, 0.02f, -0.14f, 0.02f, -0.14f)
                curveToRelative(0.43f, -1.85f, 1.89f, -3.31f, 3.75f, -3.73f)
                curveToRelative(0.04f, 0.0f, 0.08f, -0.01f, 0.12f, -0.01f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(18.0f, 10.58f, 17.68f, 10.98f, 17.25f, 11.09f)
                close()
                moveTo(18.0f, 6.06f)
                curveToRelative(0.0f, 0.51f, -0.37f, 0.92f, -0.86f, 0.99f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)
                curveToRelative(-3.19f, 0.39f, -5.7f, 2.91f, -6.09f, 6.1f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)
                curveTo(10.98f, 13.63f, 10.56f, 14.0f, 10.06f, 14.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.02f, 0.0f, -0.04f, 0.0f, -0.06f)
                curveToRelative(0.0f, -0.01f, 0.0f, -0.02f, 0.0f, -0.03f)
                curveToRelative(0.5f, -4.12f, 3.79f, -7.38f, 7.92f, -7.85f)
                curveToRelative(0.0f, 0.0f, 0.01f, 0.0f, 0.01f, 0.0f)
                curveTo(17.55f, 5.06f, 18.0f, 5.51f, 18.0f, 6.06f)
                close()
            }
        }
        return _connectWithoutContact!!
    }

private var _connectWithoutContact: ImageVector? = null
