/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Pentagon: ImageVector
    get() {
        if (_pentagon != null) {
            return _pentagon!!
        }
        _pentagon = materialIcon(name = "Outlined.Pentagon") {
            materialPath {
                moveTo(19.63f, 9.78f)
                lineTo(16.56f, 19.0f)
                horizontalLineTo(7.44f)
                lineTo(4.37f, 9.78f)
                lineTo(12.0f, 4.44f)
                lineTo(19.63f, 9.78f)
                close()
                moveTo(2.0f, 9.0f)
                lineToRelative(4.0f, 12.0f)
                horizontalLineToRelative(12.0f)
                lineToRelative(4.0f, -12.0f)
                lineTo(12.0f, 2.0f)
                lineTo(2.0f, 9.0f)
                close()
            }
        }
        return _pentagon!!
    }

private var _pentagon: ImageVector? = null
