/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ShapeLine: ImageVector
    get() {
        if (_shapeLine != null) {
            return _shapeLine!!
        }
        _shapeLine = materialIcon(name = "TwoTone.ShapeLine") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(16.0f, 16.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(-5.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.0f, 6.0f)
                moveToRelative(-3.0f, 0.0f)
                arcToRelative(3.0f, 3.0f, 0.0f, true, true, 6.0f, 0.0f)
                arcToRelative(3.0f, 3.0f, 0.0f, true, true, -6.0f, 0.0f)
            }
            materialPath {
                moveTo(6.0f, 11.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, -2.24f, 5.0f, -5.0f)
                reflectiveCurveTo(8.76f, 1.0f, 6.0f, 1.0f)
                reflectiveCurveTo(1.0f, 3.24f, 1.0f, 6.0f)
                reflectiveCurveTo(3.24f, 11.0f, 6.0f, 11.0f)
                close()
                moveTo(6.0f, 3.0f)
                curveToRelative(1.65f, 0.0f, 3.0f, 1.35f, 3.0f, 3.0f)
                curveToRelative(0.0f, 1.65f, -1.35f, 3.0f, -3.0f, 3.0f)
                reflectiveCurveTo(3.0f, 7.65f, 3.0f, 6.0f)
                curveTo(3.0f, 4.35f, 4.35f, 3.0f, 6.0f, 3.0f)
                close()
            }
            materialPath {
                moveTo(21.0f, 14.0f)
                horizontalLineToRelative(-5.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(5.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(5.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-5.0f)
                curveTo(23.0f, 14.9f, 22.1f, 14.0f, 21.0f, 14.0f)
                close()
                moveTo(21.0f, 21.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(5.0f)
                verticalLineTo(21.0f)
                close()
            }
            materialPath {
                moveTo(17.71f, 7.7f)
                curveTo(18.11f, 7.89f, 18.54f, 8.0f, 19.0f, 8.0f)
                curveToRelative(1.65f, 0.0f, 3.0f, -1.35f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.35f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.35f, -3.0f, 3.0f)
                curveToRelative(0.0f, 0.46f, 0.11f, 0.89f, 0.3f, 1.29f)
                lineTo(6.29f, 16.3f)
                curveTo(5.89f, 16.11f, 5.46f, 16.0f, 5.0f, 16.0f)
                curveToRelative(-1.65f, 0.0f, -3.0f, 1.35f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.35f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.35f, 3.0f, -3.0f)
                curveToRelative(0.0f, -0.46f, -0.11f, -0.89f, -0.3f, -1.29f)
                lineTo(17.71f, 7.7f)
                close()
            }
        }
        return _shapeLine!!
    }

private var _shapeLine: ImageVector? = null
