/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.HomeWork: ImageVector
    get() {
        if (_homeWork != null) {
            return _homeWork!!
        }
        _homeWork = materialIcon(name = "TwoTone.HomeWork") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(17.0f, 11.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(-9.0f)
                verticalLineToRelative(1.4f)
                lineToRelative(5.0f, 3.57f)
                verticalLineTo(11.0f)
                close()
                moveTo(17.0f, 7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(7.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 3.0f)
                lineToRelative(0.0f, 1.97f)
                lineToRelative(0.96f, 0.69f)
                lineToRelative(1.04f, 0.74f)
                lineToRelative(0.0f, -1.4f)
                lineToRelative(9.0f, 0.0f)
                lineToRelative(0.0f, 14.0f)
                lineToRelative(-4.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(6.0f, 0.0f)
                lineToRelative(0.0f, -18.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(3.0f, 12.0f)
                lineToRelative(0.0f, 7.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, -5.0f)
                lineToRelative(6.0f, 0.0f)
                lineToRelative(0.0f, 5.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, -7.0f)
                lineToRelative(-5.0f, -3.5f)
                close()
            }
            materialPath {
                moveTo(17.0f, 7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 11.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 15.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(1.0f, 11.0f)
                verticalLineToRelative(10.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(11.0f)
                lineTo(8.0f, 6.0f)
                lineTo(1.0f, 11.0f)
                close()
                moveTo(13.0f, 19.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(5.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(-7.0f)
                lineToRelative(5.0f, -3.5f)
                lineToRelative(5.0f, 3.5f)
                verticalLineTo(19.0f)
                close()
            }
        }
        return _homeWork!!
    }

private var _homeWork: ImageVector? = null
