/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Shop2: ImageVector
    get() {
        if (_shop2 != null) {
            return _shop2!!
        }
        _shop2 = materialIcon(name = "Rounded.Shop2") {
            materialPath {
                moveTo(2.0f, 9.0f)
                lineTo(2.0f, 9.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(10.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(15.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(10.0f)
                curveTo(3.0f, 9.45f, 2.55f, 9.0f, 2.0f, 9.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 5.0f)
                verticalLineTo(3.0f)
                curveToRelative(0.0f, -1.11f, -0.89f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(-1.11f, 0.0f, -2.0f, 0.89f, -2.0f, 2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(11.0f)
                curveToRelative(0.0f, 1.11f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.11f, 0.0f, 2.0f, -0.89f, 2.0f, -2.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(18.0f)
                close()
                moveTo(12.0f, 3.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(3.0f)
                close()
                moveTo(12.0f, 14.09f)
                verticalLineTo(8.91f)
                curveToRelative(0.0f, -0.39f, 0.44f, -0.63f, 0.77f, -0.42f)
                lineToRelative(4.07f, 2.59f)
                curveToRelative(0.31f, 0.2f, 0.31f, 0.65f, 0.0f, 0.84f)
                lineToRelative(-4.07f, 2.59f)
                curveTo(12.44f, 14.72f, 12.0f, 14.48f, 12.0f, 14.09f)
                close()
            }
        }
        return _shop2!!
    }

private var _shop2: ImageVector? = null
