/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.NearMeDisabled: ImageVector
    get() {
        if (_nearMeDisabled != null) {
            return _nearMeDisabled!!
        }
        _nearMeDisabled = materialIcon(name = "Outlined.NearMeDisabled") {
            materialPath {
                moveTo(12.0f, 6.34f)
                lineTo(21.0f, 3.0f)
                lineToRelative(-3.34f, 9.0f)
                lineToRelative(-1.56f, -1.56f)
                lineToRelative(1.5f, -4.05f)
                lineToRelative(-4.05f, 1.5f)
                lineTo(12.0f, 6.34f)
                close()
                moveTo(21.19f, 21.19f)
                lineToRelative(-5.07f, -5.07f)
                lineTo(14.31f, 21.0f)
                horizontalLineTo(12.9f)
                lineToRelative(-2.83f, -7.07f)
                lineTo(3.0f, 11.1f)
                verticalLineTo(9.69f)
                lineToRelative(4.88f, -1.81f)
                lineTo(2.81f, 2.81f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(18.38f, 18.38f)
                lineTo(21.19f, 21.19f)
                close()
                moveTo(14.57f, 14.57f)
                lineTo(9.43f, 9.43f)
                lineToRelative(-2.71f, 1.01f)
                lineToRelative(4.89f, 1.95f)
                lineToRelative(1.95f, 4.89f)
                lineTo(14.57f, 14.57f)
                close()
            }
        }
        return _nearMeDisabled!!
    }

private var _nearMeDisabled: ImageVector? = null
