/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.MacroOff: ImageVector
    get() {
        if (_macroOff != null) {
            return _macroOff!!
        }
        _macroOff = materialIcon(name = "Outlined.MacroOff") {
            materialPath {
                moveTo(8.66f, 4.93f)
                curveTo(8.9f, 4.93f, 9.12f, 5.0f, 9.3f, 5.13f)
                lineToRelative(0.81f, 0.56f)
                curveTo(9.82f, 5.93f, 9.57f, 6.23f, 9.39f, 6.56f)
                lineToRelative(1.66f, 1.66f)
                curveTo(11.03f, 8.14f, 11.0f, 8.08f, 11.0f, 8.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                curveToRelative(-0.08f, 0.0f, -0.14f, -0.03f, -0.22f, -0.04f)
                lineToRelative(4.06f, 4.06f)
                curveToRelative(1.49f, -0.24f, 2.63f, -1.53f, 2.63f, -3.09f)
                curveToRelative(0.0f, -0.71f, -0.25f, -1.39f, -0.67f, -1.93f)
                curveToRelative(0.43f, -0.54f, 0.67f, -1.22f, 0.67f, -1.93f)
                curveToRelative(0.0f, -1.73f, -1.41f, -3.14f, -3.14f, -3.14f)
                curveToRelative(-0.15f, 0.0f, -0.29f, 0.01f, -0.43f, 0.03f)
                curveTo(14.44f, 1.81f, 13.31f, 1.0f, 12.0f, 1.0f)
                reflectiveCurveTo(9.56f, 1.81f, 9.09f, 2.96f)
                curveTo(8.95f, 2.94f, 8.8f, 2.93f, 8.66f, 2.93f)
                curveToRelative(-0.8f, 0.0f, -1.53f, 0.31f, -2.09f, 0.81f)
                lineToRelative(1.42f, 1.42f)
                curveTo(8.19f, 5.03f, 8.41f, 4.93f, 8.66f, 4.93f)
                close()
                moveTo(15.34f, 11.07f)
                curveToRelative(-0.24f, 0.0f, -0.46f, -0.07f, -0.64f, -0.2f)
                lineToRelative(-0.81f, -0.57f)
                curveToRelative(0.55f, -0.45f, 0.94f, -1.09f, 1.06f, -1.83f)
                lineToRelative(0.88f, 0.42f)
                curveToRelative(0.4f, 0.19f, 0.66f, 0.59f, 0.66f, 1.03f)
                curveTo(16.49f, 10.56f, 15.97f, 11.07f, 15.34f, 11.07f)
                close()
                moveTo(14.69f, 5.13f)
                curveToRelative(0.2f, -0.13f, 0.42f, -0.2f, 0.65f, -0.2f)
                curveToRelative(0.63f, 0.0f, 1.14f, 0.51f, 1.14f, 1.14f)
                curveToRelative(0.0f, 0.44f, -0.25f, 0.83f, -0.66f, 1.03f)
                lineToRelative(-0.88f, 0.42f)
                curveToRelative(-0.12f, -0.74f, -0.51f, -1.38f, -1.07f, -1.83f)
                lineTo(14.69f, 5.13f)
                close()
                moveTo(12.0f, 3.0f)
                curveToRelative(0.62f, 0.0f, 1.12f, 0.49f, 1.14f, 1.1f)
                lineToRelative(-0.11f, 1.09f)
                curveTo(12.71f, 5.07f, 12.36f, 5.0f, 12.0f, 5.0f)
                reflectiveCurveToRelative(-0.7f, 0.07f, -1.02f, 0.19f)
                lineTo(10.86f, 4.1f)
                curveTo(10.88f, 3.49f, 11.38f, 3.0f, 12.0f, 3.0f)
                close()
            }
            materialPath {
                moveTo(19.98f, 17.15f)
                curveTo(20.63f, 15.91f, 21.0f, 14.5f, 21.0f, 13.0f)
                curveToRelative(-1.5f, 0.0f, -2.91f, 0.37f, -4.15f, 1.02f)
                lineTo(19.98f, 17.15f)
                close()
            }
            materialPath {
                moveTo(3.0f, 13.0f)
                curveToRelative(0.0f, 4.97f, 4.03f, 9.0f, 9.0f, 9.0f)
                curveTo(12.0f, 17.03f, 7.97f, 13.0f, 3.0f, 13.0f)
                close()
                moveTo(5.44f, 15.44f)
                curveToRelative(1.9f, 0.71f, 3.42f, 2.22f, 4.12f, 4.12f)
                curveTo(7.66f, 18.85f, 6.15f, 17.34f, 5.44f, 15.44f)
                close()
            }
            materialPath {
                moveTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(4.42f, 4.42f)
                curveToRelative(-0.19f, 0.4f, -0.3f, 0.84f, -0.3f, 1.29f)
                curveToRelative(0.0f, 1.73f, 1.41f, 3.14f, 3.15f, 3.14f)
                curveToRelative(0.15f, 0.0f, 0.29f, -0.01f, 0.43f, -0.03f)
                curveTo(9.56f, 14.19f, 10.69f, 15.0f, 12.0f, 15.0f)
                curveToRelative(0.05f, 0.0f, 0.11f, -0.01f, 0.16f, -0.01f)
                lineToRelative(1.64f, 1.64f)
                curveTo(12.67f, 18.12f, 12.0f, 19.98f, 12.0f, 22.0f)
                curveToRelative(2.02f, 0.0f, 3.88f, -0.67f, 5.38f, -1.8f)
                lineToRelative(2.4f, 2.4f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                close()
                moveTo(14.44f, 19.56f)
                curveToRelative(0.2f, -0.54f, 0.47f, -1.04f, 0.79f, -1.5f)
                lineToRelative(0.72f, 0.72f)
                curveTo(15.48f, 19.09f, 14.98f, 19.36f, 14.44f, 19.56f)
                close()
            }
        }
        return _macroOff!!
    }

private var _macroOff: ImageVector? = null
