/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Grade: ImageVector
    get() {
        if (_grade != null) {
            return _grade!!
        }
        _grade = materialIcon(name = "TwoTone.Grade") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(17.11f, 10.83f)
                lineToRelative(-2.47f, -0.21f)
                lineToRelative(-1.2f, -0.1f)
                lineToRelative(-0.47f, -1.11f)
                lineTo(12.0f, 7.13f)
                lineToRelative(-0.97f, 2.28f)
                lineToRelative(-0.47f, 1.11f)
                lineToRelative(-1.2f, 0.1f)
                lineToRelative(-2.47f, 0.21f)
                lineToRelative(1.88f, 1.63f)
                lineToRelative(0.91f, 0.79f)
                lineToRelative(-0.27f, 1.17f)
                lineToRelative(-0.57f, 2.42f)
                lineToRelative(2.13f, -1.28f)
                lineToRelative(1.03f, -0.63f)
                lineToRelative(1.03f, 0.63f)
                lineToRelative(2.13f, 1.28f)
                lineToRelative(-0.57f, -2.42f)
                lineToRelative(-0.27f, -1.17f)
                lineToRelative(0.91f, -0.79f)
                close()
            }
            materialPath {
                moveTo(22.0f, 9.24f)
                lineToRelative(-7.19f, -0.61f)
                lineTo(12.0f, 2.0f)
                lineTo(9.19f, 8.63f)
                lineTo(2.0f, 9.24f)
                lineToRelative(5.46f, 4.73f)
                lineTo(5.82f, 21.0f)
                lineTo(12.0f, 17.27f)
                lineTo(18.18f, 21.0f)
                lineToRelative(-1.64f, -7.03f)
                lineTo(22.0f, 9.24f)
                close()
                moveTo(14.59f, 14.42f)
                lineToRelative(0.56f, 2.41f)
                lineToRelative(-2.12f, -1.28f)
                lineToRelative(-1.03f, -0.62f)
                lineToRelative(-1.03f, 0.62f)
                lineToRelative(-2.12f, 1.28f)
                lineToRelative(0.56f, -2.41f)
                lineToRelative(0.27f, -1.18f)
                lineToRelative(-0.91f, -0.79f)
                lineToRelative(-1.88f, -1.63f)
                lineToRelative(2.47f, -0.21f)
                lineToRelative(1.2f, -0.1f)
                lineToRelative(0.47f, -1.11f)
                lineToRelative(0.97f, -2.27f)
                lineToRelative(0.97f, 2.29f)
                lineToRelative(0.47f, 1.11f)
                lineToRelative(1.2f, 0.1f)
                lineToRelative(2.47f, 0.21f)
                lineToRelative(-1.88f, 1.63f)
                lineToRelative(-0.91f, 0.79f)
                lineToRelative(0.27f, 1.16f)
                close()
            }
        }
        return _grade!!
    }

private var _grade: ImageVector? = null
