/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ModeNight: ImageVector
    get() {
        if (_modeNight != null) {
            return _modeNight!!
        }
        _modeNight = materialIcon(name = "Rounded.ModeNight") {
            materialPath {
                moveTo(11.93f, 2.3f)
                curveTo(9.89f, 1.8f, 7.91f, 1.95f, 6.16f, 2.58f)
                curveTo(5.44f, 2.84f, 5.25f, 3.8f, 5.85f, 4.29f)
                curveTo(8.08f, 6.12f, 9.5f, 8.89f, 9.5f, 12.0f)
                curveToRelative(0.0f, 3.11f, -1.42f, 5.88f, -3.65f, 7.71f)
                curveToRelative(-0.59f, 0.49f, -0.42f, 1.45f, 0.31f, 1.7f)
                curveTo(7.2f, 21.79f, 8.33f, 22.0f, 9.5f, 22.0f)
                curveToRelative(6.05f, 0.0f, 10.85f, -5.38f, 9.87f, -11.6f)
                curveTo(18.76f, 6.48f, 15.78f, 3.24f, 11.93f, 2.3f)
                close()
            }
        }
        return _modeNight!!
    }

private var _modeNight: ImageVector? = null
