/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SwipeUpAlt: ImageVector
    get() {
        if (_swipeUpAlt != null) {
            return _swipeUpAlt!!
        }
        _swipeUpAlt = materialIcon(name = "Outlined.SwipeUpAlt") {
            materialPath {
                moveTo(13.0f, 5.83f)
                lineToRelative(1.59f, 1.59f)
                lineTo(16.0f, 6.0f)
                lineToRelative(-4.0f, -4.0f)
                lineTo(8.0f, 6.0f)
                lineToRelative(1.41f, 1.41f)
                lineTo(11.0f, 5.83f)
                verticalLineToRelative(4.27f)
                curveToRelative(-2.28f, 0.46f, -4.0f, 2.48f, -4.0f, 4.9f)
                curveToRelative(0.0f, 2.76f, 2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.24f, 5.0f, -5.0f)
                curveToRelative(0.0f, -2.42f, -1.72f, -4.44f, -4.0f, -4.9f)
                verticalLineTo(5.83f)
                close()
                moveTo(12.0f, 18.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.34f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.34f, 3.0f, 3.0f)
                reflectiveCurveTo(13.66f, 18.0f, 12.0f, 18.0f)
                close()
            }
        }
        return _swipeUpAlt!!
    }

private var _swipeUpAlt: ImageVector? = null
