/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Http: ImageVector
    get() {
        if (_http != null) {
            return _http!!
        }
        _http = materialIcon(name = "Filled.Http") {
            materialPath {
                moveTo(4.5f, 11.0f)
                horizontalLineToRelative(-2.0f)
                lineTo(2.5f, 9.0f)
                lineTo(1.0f, 9.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-2.5f)
                horizontalLineToRelative(2.0f)
                lineTo(4.5f, 15.0f)
                lineTo(6.0f, 15.0f)
                lineTo(6.0f, 9.0f)
                lineTo(4.5f, 9.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(7.0f, 10.5f)
                horizontalLineToRelative(1.5f)
                lineTo(8.5f, 15.0f)
                lineTo(10.0f, 15.0f)
                verticalLineToRelative(-4.5f)
                horizontalLineToRelative(1.5f)
                lineTo(11.5f, 9.0f)
                lineTo(7.0f, 9.0f)
                verticalLineToRelative(1.5f)
                close()
                moveTo(12.5f, 10.5f)
                lineTo(14.0f, 10.5f)
                lineTo(14.0f, 15.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-4.5f)
                lineTo(17.0f, 10.5f)
                lineTo(17.0f, 9.0f)
                horizontalLineToRelative(-4.5f)
                verticalLineToRelative(1.5f)
                close()
                moveTo(21.5f, 9.0f)
                lineTo(18.0f, 9.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.8f, 0.0f, 1.5f, -0.7f, 1.5f, -1.5f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.8f, -0.7f, -1.5f, -1.5f, -1.5f)
                close()
                moveTo(21.5f, 11.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.0f)
                close()
            }
        }
        return _http!!
    }

private var _http: ImageVector? = null
