/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SportsEsports: ImageVector
    get() {
        if (_sportsEsports != null) {
            return _sportsEsports!!
        }
        _sportsEsports = materialIcon(name = "TwoTone.SportsEsports") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(16.53f, 7.0f)
                horizontalLineTo(7.47f)
                curveTo(6.48f, 7.0f, 5.63f, 7.74f, 5.49f, 8.72f)
                lineTo(4.4f, 16.37f)
                curveToRelative(-0.03f, 0.21f, 0.05f, 0.35f, 0.13f, 0.44f)
                curveTo(4.6f, 16.9f, 4.73f, 17.0f, 4.94f, 17.0f)
                curveToRelative(0.15f, 0.0f, 0.29f, -0.06f, 0.39f, -0.16f)
                lineTo(8.17f, 14.0f)
                horizontalLineToRelative(7.66f)
                lineToRelative(2.84f, 2.84f)
                curveToRelative(0.1f, 0.1f, 0.24f, 0.16f, 0.39f, 0.16f)
                curveToRelative(0.21f, 0.0f, 0.34f, -0.1f, 0.42f, -0.19f)
                curveToRelative(0.08f, -0.09f, 0.16f, -0.23f, 0.13f, -0.44f)
                lineToRelative(-1.09f, -7.66f)
                curveTo(18.37f, 7.74f, 17.52f, 7.0f, 16.53f, 7.0f)
                close()
                moveTo(11.0f, 11.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(11.0f)
                close()
                moveTo(15.0f, 10.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(16.0f, 9.55f, 15.55f, 10.0f, 15.0f, 10.0f)
                close()
                moveTo(17.0f, 13.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                curveTo(18.0f, 12.55f, 17.55f, 13.0f, 17.0f, 13.0f)
                close()
            }
            materialPath {
                moveTo(21.58f, 16.09f)
                lineToRelative(-1.09f, -7.66f)
                curveTo(20.21f, 6.46f, 18.52f, 5.0f, 16.53f, 5.0f)
                horizontalLineTo(7.47f)
                curveTo(5.48f, 5.0f, 3.79f, 6.46f, 3.51f, 8.43f)
                lineToRelative(-1.09f, 7.66f)
                curveTo(2.2f, 17.63f, 3.39f, 19.0f, 4.94f, 19.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.68f, 0.0f, 1.32f, -0.27f, 1.8f, -0.75f)
                lineTo(9.0f, 16.0f)
                horizontalLineToRelative(6.0f)
                lineToRelative(2.25f, 2.25f)
                curveToRelative(0.48f, 0.48f, 1.13f, 0.75f, 1.8f, 0.75f)
                horizontalLineToRelative(0.0f)
                curveTo(20.61f, 19.0f, 21.8f, 17.63f, 21.58f, 16.09f)
                close()
                moveTo(19.48f, 16.81f)
                curveTo(19.4f, 16.9f, 19.27f, 17.0f, 19.06f, 17.0f)
                curveToRelative(-0.15f, 0.0f, -0.29f, -0.06f, -0.39f, -0.16f)
                lineTo(15.83f, 14.0f)
                horizontalLineTo(8.17f)
                lineToRelative(-2.84f, 2.84f)
                curveTo(5.23f, 16.94f, 5.09f, 17.0f, 4.94f, 17.0f)
                curveToRelative(-0.21f, 0.0f, -0.34f, -0.1f, -0.42f, -0.19f)
                curveToRelative(-0.08f, -0.09f, -0.16f, -0.23f, -0.13f, -0.44f)
                lineToRelative(1.09f, -7.66f)
                curveTo(5.63f, 7.74f, 6.48f, 7.0f, 7.47f, 7.0f)
                horizontalLineToRelative(9.06f)
                curveToRelative(0.99f, 0.0f, 1.84f, 0.74f, 1.98f, 1.72f)
                lineToRelative(1.09f, 7.66f)
                curveTo(19.63f, 16.58f, 19.55f, 16.72f, 19.48f, 16.81f)
                close()
            }
            materialPath {
                moveTo(9.0f, 8.0f)
                lineToRelative(-1.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 1.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(1.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, -1.0f)
                lineToRelative(-2.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 12.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(15.0f, 9.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
        }
        return _sportsEsports!!
    }

private var _sportsEsports: ImageVector? = null
