/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.TwoTone.FollowTheSigns",
    ReplaceWith( "Icons.AutoMirrored.TwoTone.FollowTheSigns",
            "androidx.compose.material.icons.automirrored.twotone.FollowTheSigns"),
)
public val Icons.TwoTone.FollowTheSigns: ImageVector
    get() {
        if (_followTheSigns != null) {
            return _followTheSigns!!
        }
        _followTheSigns = materialIcon(name = "TwoTone.FollowTheSigns") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(17.64f, 7.75f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(-3.51f)
                verticalLineTo(4.5f)
                horizontalLineToRelative(3.51f)
                verticalLineTo(2.75f)
                lineToRelative(2.49f, 2.5f)
                lineTo(17.64f, 7.75f)
                close()
            }
            materialPath {
                moveTo(9.12f, 5.25f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveTo(8.02f, 5.25f, 9.12f, 5.25f)
                close()
                moveTo(5.38f, 8.65f)
                lineToRelative(-2.75f, 14.1f)
                horizontalLineToRelative(2.1f)
                lineToRelative(1.75f, -8.0f)
                lineToRelative(2.15f, 2.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(15.2f)
                lineToRelative(-2.05f, -2.05f)
                lineToRelative(0.6f, -3.0f)
                curveToRelative(1.3f, 1.6f, 3.25f, 2.6f, 5.45f, 2.6f)
                verticalLineToRelative(-2.0f)
                curveToRelative(-1.85f, 0.0f, -3.45f, -1.0f, -4.35f, -2.45f)
                lineTo(9.32f, 6.7f)
                curveToRelative(-0.35f, -0.6f, -1.0f, -0.95f, -1.7f, -0.95f)
                curveToRelative(-0.25f, 0.0f, -0.5f, 0.05f, -0.75f, 0.15f)
                lineTo(1.62f, 8.05f)
                verticalLineToRelative(4.7f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(9.4f)
                lineTo(5.38f, 8.65f)
                moveTo(12.62f, 1.75f)
                verticalLineToRelative(7.0f)
                horizontalLineToRelative(3.75f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-14.0f)
                horizontalLineToRelative(3.75f)
                verticalLineToRelative(-7.0f)
                horizontalLineTo(12.62f)
                close()
                moveTo(17.64f, 7.75f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(-3.51f)
                verticalLineTo(4.5f)
                horizontalLineToRelative(3.51f)
                verticalLineTo(2.75f)
                lineToRelative(2.49f, 2.5f)
                lineTo(17.64f, 7.75f)
                close()
            }
        }
        return _followTheSigns!!
    }

private var _followTheSigns: ImageVector? = null
