/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.WbCloudy: ImageVector
    get() {
        if (_wbCloudy != null) {
            return _wbCloudy!!
        }
        _wbCloudy = materialIcon(name = "Rounded.WbCloudy") {
            materialPath {
                moveTo(19.37f, 10.04f)
                curveTo(18.68f, 6.59f, 15.65f, 4.0f, 12.01f, 4.0f)
                curveToRelative(-2.89f, 0.0f, -5.4f, 1.64f, -6.65f, 4.04f)
                curveTo(2.35f, 8.36f, 0.01f, 10.91f, 0.01f, 14.0f)
                curveToRelative(0.0f, 3.31f, 2.69f, 6.0f, 6.0f, 6.0f)
                horizontalLineToRelative(13.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, -2.24f, 5.0f, -5.0f)
                curveToRelative(0.0f, -2.64f, -2.05f, -4.78f, -4.64f, -4.96f)
                close()
            }
        }
        return _wbCloudy!!
    }

private var _wbCloudy: ImageVector? = null
