/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.RvHookup: ImageVector
    get() {
        if (_rvHookup != null) {
            return _rvHookup!!
        }
        _rvHookup = materialIcon(name = "Rounded.RvHookup") {
            materialPath {
                moveTo(21.0f, 17.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                lineTo(7.0f, 9.0f)
                verticalLineToRelative(-0.74f)
                curveToRelative(0.0f, -0.46f, -0.56f, -0.7f, -0.89f, -0.37f)
                lineTo(4.37f, 9.63f)
                curveToRelative(-0.2f, 0.2f, -0.2f, 0.53f, 0.0f, 0.74f)
                lineToRelative(1.74f, 1.74f)
                curveToRelative(0.33f, 0.33f, 0.89f, 0.1f, 0.89f, -0.37f)
                lineTo(7.0f, 11.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(3.0f)
                lineTo(5.0f, 14.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                horizontalLineToRelative(7.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveToRelative(-0.45f, -1.0f, -1.0f, -1.0f)
                close()
                moveTo(11.0f, 20.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                close()
                moveTo(18.0f, 14.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(10.0f, 6.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(0.74f)
                curveToRelative(0.0f, 0.46f, 0.56f, 0.7f, 0.89f, 0.37f)
                lineToRelative(1.74f, -1.74f)
                curveToRelative(0.2f, -0.2f, 0.2f, -0.53f, 0.0f, -0.74f)
                lineToRelative(-1.74f, -1.74f)
                curveToRelative(-0.33f, -0.33f, -0.89f, -0.1f, -0.89f, 0.37f)
                lineTo(17.0f, 4.0f)
                horizontalLineToRelative(-7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                close()
            }
        }
        return _rvHookup!!
    }

private var _rvHookup: ImageVector? = null
