/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.KeyboardOptionKey: ImageVector
    get() {
        if (_keyboardOptionKey != null) {
            return _keyboardOptionKey!!
        }
        _keyboardOptionKey = materialIcon(name = "Sharp.KeyboardOptionKey") {
            materialPath {
                moveTo(15.0f, 5.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-6.0f)
                close()
            }
            materialPath {
                moveTo(9.0f, 5.0f)
                lineToRelative(-6.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(4.85f, 0.0f)
                lineToRelative(6.92f, 12.0f)
                lineToRelative(6.23f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-5.07f, 0.0f)
                close()
            }
        }
        return _keyboardOptionKey!!
    }

private var _keyboardOptionKey: ImageVector? = null
