/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded._4k: ImageVector
    get() {
        if (__4k != null) {
            return __4k!!
        }
        __4k = materialIcon(name = "Rounded._4k") {
            materialPath {
                moveTo(19.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.89f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(12.0f, 12.76f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                lineTo(11.0f, 13.51f)
                verticalLineToRelative(0.74f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                reflectiveCurveToRelative(-0.75f, -0.34f, -0.75f, -0.75f)
                verticalLineToRelative(-0.75f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                lineTo(6.5f, 9.75f)
                curveToRelative(0.0f, -0.41f, 0.34f, -0.75f, 0.75f, -0.75f)
                reflectiveCurveToRelative(0.75f, 0.34f, 0.75f, 0.75f)
                lineTo(8.0f, 12.0f)
                horizontalLineToRelative(1.5f)
                lineTo(9.5f, 9.75f)
                curveToRelative(0.0f, -0.41f, 0.34f, -0.75f, 0.75f, -0.75f)
                reflectiveCurveToRelative(0.75f, 0.34f, 0.75f, 0.75f)
                lineTo(11.0f, 12.0f)
                horizontalLineToRelative(0.25f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                verticalLineToRelative(0.01f)
                close()
                moveTo(17.47f, 13.9f)
                curveToRelative(0.22f, 0.33f, 0.13f, 0.77f, -0.2f, 0.98f)
                curveToRelative(-0.12f, 0.08f, -0.26f, 0.12f, -0.39f, 0.12f)
                curveToRelative(-0.23f, 0.0f, -0.45f, -0.11f, -0.59f, -0.32f)
                lineTo(14.5f, 12.0f)
                verticalLineToRelative(2.24f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                curveToRelative(-0.41f, 0.01f, -0.75f, -0.33f, -0.75f, -0.74f)
                verticalLineToRelative(-4.5f)
                curveToRelative(0.0f, -0.41f, 0.34f, -0.75f, 0.75f, -0.75f)
                reflectiveCurveToRelative(0.75f, 0.34f, 0.75f, 0.75f)
                verticalLineToRelative(2.24f)
                lineToRelative(1.79f, -2.68f)
                curveToRelative(0.22f, -0.33f, 0.66f, -0.41f, 0.98f, -0.2f)
                curveToRelative(0.33f, 0.22f, 0.41f, 0.66f, 0.2f, 0.98f)
                lineTo(16.2f, 12.0f)
                lineToRelative(1.27f, 1.9f)
                close()
            }
        }
        return __4k!!
    }

private var __4k: ImageVector? = null
