/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.TakeoutDining: ImageVector
    get() {
        if (_takeoutDining != null) {
            return _takeoutDining!!
        }
        _takeoutDining = materialIcon(name = "Rounded.TakeoutDining") {
            materialPath {
                moveTo(21.29f, 6.75f)
                curveToRelative(-0.39f, -0.39f, -1.01f, -0.39f, -1.4f, 0.0f)
                lineTo(19.0f, 7.63f)
                lineToRelative(0.03f, -0.56f)
                lineToRelative(-3.46f, -3.48f)
                curveTo(15.19f, 3.21f, 14.68f, 3.0f, 14.15f, 3.0f)
                horizontalLineToRelative(-4.3f)
                curveTo(9.32f, 3.0f, 8.81f, 3.21f, 8.43f, 3.59f)
                lineTo(4.97f, 7.07f)
                lineTo(5.0f, 7.57f)
                lineTo(4.11f, 6.7f)
                curveTo(3.72f, 6.32f, 3.1f, 6.32f, 2.72f, 6.71f)
                lineTo(2.7f, 6.73f)
                curveTo(2.32f, 7.12f, 2.32f, 7.75f, 2.72f, 8.13f)
                lineTo(4.66f, 10.0f)
                horizontalLineToRelative(14.69f)
                lineToRelative(1.92f, -1.84f)
                curveTo(21.67f, 7.78f, 21.68f, 7.14f, 21.29f, 6.75f)
                close()
            }
            materialPath {
                moveTo(5.79f, 18.15f)
                curveTo(5.87f, 19.19f, 6.74f, 20.0f, 7.79f, 20.0f)
                horizontalLineToRelative(8.43f)
                curveToRelative(1.05f, 0.0f, 1.92f, -0.81f, 1.99f, -1.85f)
                lineToRelative(0.49f, -6.6f)
                horizontalLineTo(5.3f)
                lineTo(5.79f, 18.15f)
                close()
            }
        }
        return _takeoutDining!!
    }

private var _takeoutDining: ImageVector? = null
